/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ie.ChineseMorphFeatureSets;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.WordFeatureExtractor;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.pennchinese.RadicalMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChineseWordFeatureExtractor
implements WordFeatureExtractor {
    private static Redwood.RedwoodChannels log = Redwood.channels(ChineseWordFeatureExtractor.class);
    private static final long serialVersionUID = -4327267414095852504L;
    boolean morpho;
    boolean chars;
    boolean rads;
    boolean useLength;
    boolean useFreq;
    boolean bigrams;
    boolean conjunctions;
    boolean mildConjunctions;
    public boolean turnOffWordFeatures = false;
    private IntCounter wordCounter = new IntCounter();
    private ChineseMorphFeatureSets cmfs = null;
    private static final String featureDir = "gbfeatures";
    private Collection<String> threshedFeatures;

    @Override
    public void setFeatureLevel(int level) {
        this.morpho = false;
        this.chars = false;
        this.rads = false;
        this.useLength = false;
        this.useFreq = false;
        this.bigrams = false;
        this.conjunctions = false;
        this.mildConjunctions = false;
        switch (level) {
            case 3: {
                this.bigrams = true;
                this.conjunctions = true;
            }
            case 2: {
                this.chars = true;
            }
            case 1: {
                this.morpho = true;
                this.mildConjunctions = true;
                this.loadFeatures();
            }
            case 0: {
                this.rads = true;
            }
            case -1: {
                this.useLength = true;
                this.useFreq = true;
                break;
            }
            default: {
                log.info("Feature level " + level + " is not supported in ChineseWordFeatureExtractor.");
                log.info("Using level 0");
                this.setFeatureLevel(0);
            }
        }
    }

    public ChineseWordFeatureExtractor(int featureLevel) {
        this.setFeatureLevel(featureLevel);
    }

    public void train(Collection<Tree> trees) {
        this.train(trees, 1.0);
    }

    public void train(Collection<Tree> trees, double weight) {
        for (Tree tree : trees) {
            this.train(tree, weight);
        }
    }

    public void train(Tree tree, double weight) {
        this.train((List<TaggedWord>)tree.taggedYield(), weight);
    }

    public void train(List<TaggedWord> sentence, double weight) {
        for (TaggedWord word : sentence) {
            String wordString = word.word();
            this.wordCounter.incrementCount(wordString, weight);
        }
    }

    private void loadFeatures() {
        if (this.cmfs != null) {
            return;
        }
        this.cmfs = new ChineseMorphFeatureSets(featureDir);
        log.info("Total affix features: " + this.cmfs.getAffixFeatures().size());
    }

    @Override
    public void applyFeatureCountThreshold(Collection<String> data, int thresh) {
        IntCounter<String> c = new IntCounter<String>();
        for (String datum : data) {
            for (String feat : this.makeFeatures(datum)) {
                c.incrementCount(feat);
            }
        }
        this.threshedFeatures = c.keysAbove(thresh);
        log.info(c.size() - this.threshedFeatures.size() + " word features removed due to thresholding.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<String> makeFeatures(String word) {
        ArrayList<String> features = new ArrayList<String>();
        if (this.morpho) {
            for (Map.Entry<String, Set<Character>> entry : this.cmfs.getSingletonFeatures().entrySet()) {
                if (!entry.getValue().contains(Character.valueOf(word.charAt(0)))) continue;
                features.add(entry.getKey() + "-1");
            }
            for (Map.Entry<String, Object> entry : this.cmfs.getAffixFeatures().entrySet()) {
                boolean both = false;
                if (((Set)((Pair)entry.getValue()).first()).contains(Character.valueOf(word.charAt(0)))) {
                    features.add(entry.getKey() + "-P");
                    both = true;
                }
                if (((Set)((Pair)entry.getValue()).second()).contains(Character.valueOf(word.charAt(word.length() - 1)))) {
                    features.add(entry.getKey() + "-S");
                } else {
                    both = false;
                }
                if (!both || !this.mildConjunctions || this.conjunctions) continue;
                features.add(entry.getKey() + "-PS");
            }
            if (this.conjunctions) {
                int n;
                int max = features.size();
                boolean bl = true;
                while (n < max) {
                    String s1 = (String)features.get(n);
                    for (int j = 0; j < n; ++j) {
                        String s2 = (String)features.get(j);
                        features.add(s1 + "&&" + s2);
                    }
                    ++n;
                }
            }
        }
        if (!this.turnOffWordFeatures) {
            features.add(word + "-W");
        }
        if (this.rads) {
            features.add(RadicalMap.getRadical(word.charAt(0)) + "-FR");
            features.add(RadicalMap.getRadical(word.charAt(word.length() - 1)) + "-LR");
            for (int i = 0; i < word.length(); ++i) {
                features.add(RadicalMap.getRadical(word.charAt(i)) + "-CR");
            }
        }
        if (this.chars) {
            int i;
            features.add(word.charAt(0) + "-FC");
            features.add(word.charAt(word.length() - 1) + "-LC");
            for (i = 0; i < word.length(); ++i) {
                features.add(word.charAt(i) + "-CC");
            }
            if (this.bigrams && word.length() > 1) {
                features.add(word.substring(0, 2) + "-FB");
                features.add(word.substring(word.length() - 2) + "-LB");
                for (i = 2; i <= word.length(); ++i) {
                    features.add(word.substring(i - 2, i) + "-CB");
                }
            }
        }
        if (this.useLength) {
            int lengthBin = word.length();
            if (lengthBin >= 5) {
                lengthBin = lengthBin >= 8 ? 8 : 5;
            }
            features.add(word.length() + "-L");
        }
        if (this.useFreq && !this.turnOffWordFeatures) {
            void var4_21;
            int freq = this.wordCounter.getIntCount(word);
            if (freq <= 1) {
                boolean bl = false;
            } else if (freq <= 3) {
                boolean bl = true;
            } else if (freq <= 6) {
                int n = 2;
            } else if (freq <= 15) {
                int n = 3;
            } else if (freq <= 50) {
                int n = 4;
            } else {
                int n = 5;
            }
            features.add((int)var4_21 + "-FQ");
        }
        features.add("PR");
        if (this.threshedFeatures != null) {
            Iterator iter = features.iterator();
            while (iter.hasNext()) {
                String string = (String)iter.next();
                if (this.threshedFeatures.contains(string)) continue;
                iter.remove();
            }
        }
        return features;
    }
}

