/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ie.util.IETestUtils;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.naturalli.RelationTripleSegmenter;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import junit.framework.TestCase;

public class RelationTripleSegmenterTest
extends TestCase {
    protected Optional<RelationTriple> mkExtraction(String conll) {
        return this.mkExtraction(conll, 0, false);
    }

    protected Optional<RelationTriple> mkExtraction(String conll, boolean allNominals) {
        return this.mkExtraction(conll, 0, allNominals);
    }

    protected Optional<RelationTriple> mkExtraction(String conll, int listIndex) {
        return this.mkExtraction(conll, listIndex, false);
    }

    protected Pair<SemanticGraph, List<CoreLabel>> mkTree(String conll) {
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        SemanticGraph tree = new SemanticGraph();
        for (String line : conll.split("\n")) {
            if (line.trim().equals("")) continue;
            String[] fields = line.trim().split("\\s+");
            int index = Integer.parseInt(fields[0]);
            String word = fields[1];
            CoreLabel label = IETestUtils.mkWord(word, index);
            sentence.add(label);
            if (fields[2].equals("0")) {
                tree.addRoot(new IndexedWord(label));
            } else {
                tree.addVertex(new IndexedWord(label));
            }
            if (fields.length > 4) {
                label.setTag(fields[4]);
            }
            if (fields.length > 5) {
                label.setNER(fields[5]);
            }
            if (fields.length <= 6) continue;
            label.setLemma(fields[6]);
        }
        int i = 0;
        for (String line : conll.split("\n")) {
            if (line.trim().equals("")) continue;
            String[] fields = line.trim().split("\\s+");
            int parent = Integer.parseInt(fields[2]);
            String reln = fields[3];
            if (parent > 0) {
                tree.addEdge(new IndexedWord((CoreLabel)sentence.get(parent - 1)), new IndexedWord((CoreLabel)sentence.get(i)), new GrammaticalRelation(Language.UniversalEnglish, reln, null, null), 1.0, false);
            }
            ++i;
        }
        return Pair.makePair(tree, sentence);
    }

    protected Optional<RelationTriple> mkExtraction(String conll, int listIndex, boolean allNominals) {
        Pair<SemanticGraph, List<CoreLabel>> info = this.mkTree(conll);
        SemanticGraph tree = (SemanticGraph)info.first;
        List sentence = (List)info.second;
        Optional<RelationTriple> segmented = new RelationTripleSegmenter(allNominals).segment(tree, Optional.empty());
        if (segmented.isPresent() && listIndex == 0) {
            return segmented;
        }
        List<RelationTriple> extracted = new RelationTripleSegmenter(allNominals).extract(tree, sentence);
        if (extracted.size() > listIndex) {
            return Optional.of(extracted.get(listIndex - (segmented.isPresent() ? 1 : 0)));
        }
        return Optional.empty();
    }

    protected RelationTriple blueCatsPlayWithYarnNoIndices() {
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        sentence.add(IETestUtils.mkWord("blue", -1));
        sentence.add(IETestUtils.mkWord("cats", -1));
        sentence.add(IETestUtils.mkWord("play", -1));
        sentence.add(IETestUtils.mkWord("with", -1));
        sentence.add(IETestUtils.mkWord("yarn", -1));
        return new RelationTriple(sentence.subList(0, 2), sentence.subList(2, 4), sentence.subList(4, 5));
    }

    protected RelationTriple blueCatsPlayWithYarn() {
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        sentence.add(IETestUtils.mkWord("blue", 0));
        sentence.add(IETestUtils.mkWord("cats", 1));
        sentence.add(IETestUtils.mkWord("play", 2));
        sentence.add(IETestUtils.mkWord("with", 3));
        sentence.add(IETestUtils.mkWord("yarn", 4));
        return new RelationTriple(sentence.subList(0, 2), sentence.subList(2, 4), sentence.subList(4, 5));
    }

    protected RelationTriple yarnBlueCatsPlayWith() {
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        sentence.add(IETestUtils.mkWord("yarn", 0));
        sentence.add(IETestUtils.mkWord("blue", 1));
        sentence.add(IETestUtils.mkWord("cats", 2));
        sentence.add(IETestUtils.mkWord("play", 3));
        sentence.add(IETestUtils.mkWord("with", 4));
        return new RelationTriple(sentence.subList(1, 3), sentence.subList(3, 5), sentence.subList(0, 1));
    }

    public void testToSentenceNoIndices() {
        RelationTripleSegmenterTest.assertEquals((Object)new ArrayList<CoreLabel>(){
            {
                this.add(IETestUtils.mkWord("blue", -1));
                this.add(IETestUtils.mkWord("cats", -1));
                this.add(IETestUtils.mkWord("play", -1));
                this.add(IETestUtils.mkWord("with", -1));
                this.add(IETestUtils.mkWord("yarn", -1));
            }
        }, this.blueCatsPlayWithYarnNoIndices().asSentence());
    }

    public void testToSentenceInOrder() {
        RelationTripleSegmenterTest.assertEquals((Object)new ArrayList<CoreLabel>(){
            {
                this.add(IETestUtils.mkWord("blue", 0));
                this.add(IETestUtils.mkWord("cats", 1));
                this.add(IETestUtils.mkWord("play", 2));
                this.add(IETestUtils.mkWord("with", 3));
                this.add(IETestUtils.mkWord("yarn", 4));
            }
        }, this.blueCatsPlayWithYarn().asSentence());
    }

    public void testToSentenceOutOfOrder() {
        RelationTripleSegmenterTest.assertEquals((Object)new ArrayList<CoreLabel>(){
            {
                this.add(IETestUtils.mkWord("yarn", 0));
                this.add(IETestUtils.mkWord("blue", 1));
                this.add(IETestUtils.mkWord("cats", 2));
                this.add(IETestUtils.mkWord("play", 3));
                this.add(IETestUtils.mkWord("with", 4));
            }
        }, this.yarnBlueCatsPlayWith().asSentence());
    }

    public void testSameSemanticsForDifferentWordOrder() {
        RelationTripleSegmenterTest.assertEquals((String)this.blueCatsPlayWithYarn().toString(), (String)this.yarnBlueCatsPlayWith().toString());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tblue cats\tplay with\tyarn", (String)this.blueCatsPlayWithYarn().toString());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tblue cats\tplay with\tyarn", (String)this.yarnBlueCatsPlayWith().toString());
    }

    public void testGlosses() {
        RelationTripleSegmenterTest.assertEquals((String)"blue cats", (String)this.blueCatsPlayWithYarn().subjectGloss());
        RelationTripleSegmenterTest.assertEquals((String)"play with", (String)this.blueCatsPlayWithYarn().relationGloss());
        RelationTripleSegmenterTest.assertEquals((String)"yarn", (String)this.blueCatsPlayWithYarn().objectGloss());
    }

    public void testBlueCatsPlayWithYarn() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tblue\t2\tamod\n2\tcats\t3\tnsubj\n3\tplay\t0\troot\n4\twith\t5\tcase\n5\tyarn\t3\tnmod:with\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tblue cats\tplay with\tyarn", (String)extraction.get().toString());
    }

    public void testBlueCatsPlayQuietlyWithYarn() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tblue\t2\tamod\n2\tcats\t3\tnsubj\n3\tplay\t0\troot\n4\tquietly\t3\tadvmod\n5\twith\t6\tcase\n6\tyarn\t3\tnmod:with\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tblue cats\tplay quietly with\tyarn", (String)extraction.get().toString());
    }

    public void testCatsHaveTails() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tcats\t2\tnsubj\n2\thave\t0\troot\n3\ttails\t2\tdobj\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tcats\thave\ttails", (String)extraction.get().toString());
    }

    public void testrabbitsEatVegetables() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\trabbits\t2\tnsubj\n2\teat\t0\troot\n3\tvegetables\t2\tdobj\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\trabbits\teat\tvegetables", (String)extraction.get().toString());
    }

    public void testFishLikeToSwim() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tfish\t2\tnsubj\n2\tlike\t0\troot\n3\tto\t4\taux\n4\tswim\t2\txcomp\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tfish\tlike\tto swim", (String)extraction.get().toString());
    }

    public void testFishLikeToSwimAlternateParse() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tfish\t2\tnsubj\n2\tlike\t0\troot\n3\tto\t4\tcase\n4\tswim\t2\tnmod:to\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tfish\tlike to\tswim", (String)extraction.get().toString());
    }

    public void testMyCatsPlayWithYarn() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tmy\t2\tnmod:poss\n2\tcats\t3\tnsubj\n3\tplay\t0\troot\n4\twith\t5\tcase\n5\tyarn\t3\tnmod:with\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tmy cats\tplay with\tyarn", (String)extraction.get().toString());
    }

    public void testCatsAreCute() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tcats\t3\tnsubj\n2\tare\t3\tcop\n3\tcute\t0\troot\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tcats\tare\tcute", (String)extraction.get().toString());
    }

    public void testIAmInFlorida() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tI\t4\tnsubj\n2\tam\t4\tcop\n3\tin\t4\tcase\n4\tFlorida\t0\troot\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tI\tam in\tFlorida", (String)extraction.get().toString());
    }

    public void testWh() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\twhat\t3\tnsubj\tWP\n2\tis\t3\tcop\tVBZ\n3\tlove\t0\troot\tNN\n");
        RelationTripleSegmenterTest.assertFalse((String)"Extracted on WH word!", (boolean)extraction.isPresent());
    }

    public void testPropagateCSubj() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\ttruffles\t2\tnsubj\n2\tpicked\t4\tcsubj\n3\tare\t4\tcop\n4\ttasty\t0\troot\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\ttruffles picked\tare\ttasty", (String)extraction.get().toString());
    }

    public void testHeWasInaugurated() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\the\t3\tnsubjpass\n2\twas\t3\tauxpass\n3\tinaugurated\t0\troot\n4\tas\t5\tcase\n5\tpresident\t3\tnmod:as\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\the\twas inaugurated as\tpresident", (String)extraction.get().toString());
    }

    public void testPPAttachment() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\the\t2\tnsubj\n2\tserved\t0\troot\n3\tas\t4\tcase\n4\tpresident\t2\tnmod:as\n5\tof\t8\tcase\n6\tHarvard\t8\tcompound\n7\tLaw\t8\tcompound\n8\tReview\t4\tnmod:of\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\the\tserved as\tpresident of Harvard Law Review", (String)extraction.get().toString());
    }

    public void testPPAttachmentTwo() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\the\t4\tnsubj\n2\twas\t4\tcop\n3\tcommunity\t4\tcompound\n4\torganizer\t0\troot\n5\tin\t6\tcase\n6\tChicago\t4\tnmod:in\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\the\twas\tcommunity organizer in Chicago", (String)extraction.get().toString());
    }

    public void testXComp() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tObama\t3\tnsubjpass\n2\twas\t3\tauxpass\n3\tnamed\t0\troot\n4\t2009\t8\tnummod\n5\tNobel\t8\tcompound\n6\tPeace\t8\tcompound\n7\tPrize\t8\tcompound\n8\tLaureate\t3\txcomp\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tObama\twas named\t2009 Nobel Peace Prize Laureate", (String)extraction.get().toString());
    }

    public void testPassiveNSubj() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tHRE\t3\tnsubjpass\n2\twas\t3\tauxpass\n3\tfounded\t0\troot\n4\tin\t5\tcase\n5\t1991\t3\tnmod:in\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tHRE\twas founded in\t1991", (String)extraction.get().toString());
        extraction = this.mkExtraction("1\tfounded\t0\troot\n2\tHRE\t1\tnsubjpass\n3\tin\t4\tcase\n4\t2003\t1\tnmod:in\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tHRE\tfounded in\t2003", (String)extraction.get().toString());
    }

    public void testPossessive() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tUnicredit\t5\tnmod:poss\tNNP\tORGANIZATION\n2\t's\t1\tcase\tPOS\tO\n3\tBank\t5\tcompound\tNNP\tORGANIZATION\n4\tAustria\t5\tcompound\tNNP\tORGANIZATION\n5\tCreditanstalt\t0\troot\tNNP\tORGANIZATION\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tUnicredit\thas\tBank Austria Creditanstalt", (String)extraction.get().toString());
    }

    public void testPossessiveNoNER() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tIBM\t4\tnmod:poss\tNNP\tORGANIZATION\n2\t's\t1\tcase\tPOS\tO\n3\tresearch\t4\tcompound\tNN\tO\n4\tgroup\t0\troot\tNN\tO\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tIBM\thas\tresearch group", (String)extraction.get().toString());
    }

    public void testPossessiveWithObject() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tTim\t3\tnmod:poss\n2\t's\t1\tcase\n3\tfather\t0\troot\n4\tTom\t3\tappos\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tTim\t's father is\tTom", (String)extraction.get().toString());
    }

    public void testApposInObject() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tNewspaper\t2\tnsubj\n2\tpublished\t0\troot\n3\tin\t4\tcase\n4\tTucson\t2\tnmod:in\n5\tArizona\t4\tappos\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tNewspaper\tpublished in\tArizona", (String)extraction.get().toString());
    }

    public void testApposAsSubj() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tDurin\t0\troot\tNNP\n2\tson\t1\tappos\tNN\n3\tof\t4\tcase\tIN\n4\tThorin\t2\tnmod:of\tNNP\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tDurin\tson of\tThorin", (String)extraction.get().toString());
    }

    public void testReflexive() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tTom\t5\tnsubj\n2\tand\t1\tcc\n3\tJerry\t1\tconj:and\n4\twere\t5\taux\n5\tfighting\t0\troot\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tTom\tfighting\tJerry", (String)extraction.get().toString());
    }

    public void testPassiveReflexive() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tTom\t5\tnsubjpass\n2\tand\t1\tcc\n3\tJerry\t1\tconj:and\n4\twere\t5\tauxpass\n5\tfighting\t0\troot\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tTom\tfighting\tJerry", (String)extraction.get().toString());
    }

    public void testPossessiveInEntity() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tScania-Vabis\t2\tnsubj\n2\testablished\t0\troot\n3\tits\t6\tnmod:poss\n4\tfirst\t6\tamod\n5\tproduction\t6\tcompound\n6\tplant\t2\tdobj\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tScania-Vabis\testablished\tits first production plant", (String)extraction.get().toString());
    }

    public void testOfWhich() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tof\t2\tcase\n2\twhich\t5\tnmod:of\n3\tBono\t5\tnsubj\n4\tis\t5\tcop\n5\tco-founder\t0\troot\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tBono\tis co-founder of\twhich", (String)extraction.get().toString());
    }

    public void testObjInRelation() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tScania-Vabis\t2\tnsubj\tNNP\tORGANIZATION\n2\testablished\t0\troot\tVB\tO\n3\tproduction\t4\tcompound\tNN\tO\n4\tplant\t2\tdobj\tNN\tO\n5\toutside\t6\tcase\tIN\tO\n6\tS\u00f6dert\u00e4lje\t2\tnmod:outside\tNN\tO\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tScania-Vabis\testablished production plant outside\tS\u00f6dert\u00e4lje", (String)extraction.get().toString());
        extraction = this.mkExtraction("1\tHun\t2\tcompound\tNNP\tPERSON\n2\tSen\t3\tnsubj\tNNP\tPERSON\n3\tplayed\t0\troot\tVBD\tO\n4\tgolf\t3\tdobj\tNN\tO\n5\twith\t6\tcase\tIN\tO\n6\tShinawatra\t3\tnmod:with\tNNP\tPERSON\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tHun Sen\tplayed golf with\tShinawatra", (String)extraction.get().toString());
        extraction = this.mkExtraction("1\tHun\t2\tcompound\tNNP\tPERSON\n2\tSen\t3\tnsubj\tNNP\tPERSON\n3\tplayed\t0\troot\tVBD\tO\n4\tgolf\t3\tdobj\tNN\tO\n5\tShinawatra\t3\tnmod:with\tNNP\tPERSON\n6\tCambodia\t3\tdobj\tNNP\tLOCATION\n");
        RelationTripleSegmenterTest.assertFalse((String)("Should not have found extraction for sentence! Incorrectly found: " + extraction.orElse(null)), (boolean)extraction.isPresent());
    }

    public void testVBG() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tfoal\t3\tnsubj\n2\tbe\t3\taux\n3\tstanding\t0\troot\n4\tnext\t3\tadvmod\t\n5\tto\t6\tcase\n6\thorse\t3\tnmod:to\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tfoal\tbe standing next to\thorse", (String)extraction.get().toString());
    }

    public void testVBGCollapsed() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tfoal\t3\tnsubj\n2\tbe\t3\taux\n3\tstanding\t0\troot\n4\tnext\t6\tcase\t\n5\tto\t4\tmwe\n6\thorse\t3\tnmod:next_to\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tfoal\tbe standing next to\thorse", (String)extraction.get().toString());
    }

    public void testThereAreIn() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tthere\t2\texpl\n2\tare\t0\troot\tVBP\tO\tbe\n3\tdogs\t2\tnsubj\tNN\n4\tin\t5\tcase\tNN\n5\theaven\t3\tnmod:in\tNN\n", true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tdogs\tis in\theaven", (String)extraction.get().toString());
    }

    public void testThereAreWith() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tthere\t2\texpl\tEX\n2\tare\t0\troot\tVBP\tO\tbe\n3\tcats\t2\tnsubj\tNN\n4\twith\t5\tcase\tIN\n5\ttails\t3\tnmod:with\tNN\n", true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tcats\tis with\ttails", (String)extraction.get().toString());
    }

    public void testThereAreVBing() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tthere\t2\texpl\n2\tare\t0\troot\tVBP\tO\tbe\n3\tdogs\t2\tnsubj\n4\tsitting\t3\tacl\n5\tin\t6\tcase\tNN\n6\theaven\t4\tnmod:in\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tdogs\tsitting in\theaven", (String)extraction.get().toString());
    }

    public void testDogsInheaven() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tdogs\t0\troot\tNN\n2\tin\t3\tcase\tNN\n3\theaven\t1\tnmod:in\tNN\n", true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tdogs\tis in\theaven", (String)extraction.get().toString());
        extraction = this.mkExtraction("1\tdogs\t0\troot\tNN\n2\tin\t3\tcase\tNN\n3\theaven\t1\tnmod:of\tNN\n", true);
        RelationTripleSegmenterTest.assertFalse((boolean)extraction.isPresent());
    }

    public void testAdvObject() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\thorses\t3\tnsubj\n2\tare\t3\tcop\n3\tgrazing\t0\troot\n4\tpeacefully\t3\tadvmod\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\thorses\tare\tgrazing peacefully", (String)extraction.get().toString());
    }

    public void testAdvObjectPassive() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tthings\t3\tnsubjpass\n2\tare\t3\tauxpass\n3\tarranged\t0\troot\n4\tneatly\t3\tadvmod\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tthings\tare\tarranged neatly", (String)extraction.get().toString());
    }

    public void testObamaBornInRegression() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tObama\t2\tnsubj\n2\tBorn\t0\troot\n3\tin\t4\tcase\n4\tHonolulu\t2\tnmod:in\n5\tHawaii\t4\tcompound\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tObama\tBorn in\tHonolulu Hawaii", (String)extraction.get().toString());
    }

    public void testObamaPresidentOfRegression() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tObama\t3\tnsubj\n2\tis\t3\tcop\n3\tpresident\t0\troot\n4\tof\t5\tcase\n5\tUS\t3\tnmod:of\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tObama\tis president of\tUS", (String)extraction.get().toString());
    }

    public void testObamaPresidentOfRegressionFull() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tObama\t6\tnsubj\n2\tis\t6\tcop\n3\t44th\t6\tamod\n4\tand\t3\tcc\n5\tcurrent\t3\tconj:and\n6\tpresident\t0\troot\n7\tof\t8\tcase\n8\tUS\t6\tnmod:of\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tObama\tis 44th and current president of\tUS", (String)extraction.get().toString());
    }

    public void testGeorgeBoydRegression() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tGeorge\t2\tcompound\n2\tBoyd\t4\tnsubj\n3\thas\t4\taux\n4\tjoined\t0\troot\n5\tNottingham\t6\tcompound\n6\tForest\t4\tdobj\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tGeorge Boyd\thas joined\tNottingham Forest", (String)extraction.get().toString());
    }

    public void testUSPresidentObama1() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tUnited\t5\tcompound\tNNP\tORGANIZATION\n2\tStates\t5\tcompound\tNNP\tORGANIZATION\n3\tpresident\t5\tcompound\tNNP\tO\n4\tBarack\t5\tcompound\tNNP\tPERSON\n5\tObama\t0\troot\tNNP\tPERSON\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tBarack Obama\tis president of\tUnited States", (String)extraction.get().toString());
    }

    public void testUSPresidentObama2() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tUnited\t5\tcompound\tNNP\tORGANIZATION\n2\tStates\t5\tcompound\tNNP\tORGANIZATION\n3\tpresident\t5\tcompound\tNNP\tTITLE\n4\tBarack\t5\tcompound\tNNP\tPERSON\n5\tObama\t0\troot\tNNP\tPERSON\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tBarack Obama\tis president of\tUnited States", (String)extraction.get().toString());
    }

    public void testUSAllyBritain() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tUnited\t4\tcompound\tNNP\tLOCATION\n2\tStates\t4\tcompound\tNNP\tLOCATION\n3\tally\t4\tcompound\tNN\tO\n4\tBritain\t0\troot\tNNP\tLOCATION\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tBritain\tis ally of\tUnited States", (String)extraction.get().toString());
    }

    public void testUSPresidentObama() {
        String conll = "1\tUnited\t2\tcompound\tNNP\tLOCATION\n2\tStates\t4\tnmod:poss\tNNP\tLOCATION\n3\t's\t2\tcase\tPOS\tO\n4\tpresident\t0\troot\tNN\tO\n5\tObama\t2\tappos\tNNP\tPERSON\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, 0);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tUnited States\thas\tpresident", (String)extraction.get().toString());
        extraction = this.mkExtraction(conll, 1);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tObama\tis president of\tUnited States", (String)extraction.get().toString());
    }

    public void testUSsAllyBritain() {
        String conll = "1\tUnited\t2\tcompound\tNNP\tLOCATION\n2\tStates\t4\tnmod:poss\tNNP\tLOCATION\n3\t's\t2\tcase\tPOS\tO\n4\tally\t0\troot\tNN\tO\n5\tBritain\t2\tappos\tNNP\tPERSON\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, 0);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tUnited States\thas\tally", (String)extraction.get().toString());
        extraction = this.mkExtraction(conll, 1);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tBritain\tis ally of\tUnited States", (String)extraction.get().toString());
    }

    public void testPresidentObama() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tPresident\t2\tcompound\tPOS\tTITLE\n2\tObama\t0\troot\tNNP\tPERSON\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tObama\tis\tPresident", (String)extraction.get().toString());
    }

    public void testAmericanActorChrisPratt() {
        String conll = "1\tAmerican\t4\tamod\tNN\tLOCATION\n2\tactor\t4\tcompound\tNN\tTITLE\n3\tChris\t4\tcompound\tNNP\tPERSON\n4\tPratt\t0\troot\tNNP\tPERSON\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, 0);
        RelationTripleSegmenterTest.assertTrue((String)"No first extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tChris Pratt\tis actor of\tAmerican", (String)extraction.get().toString());
        extraction = this.mkExtraction(conll, 1);
        RelationTripleSegmenterTest.assertTrue((String)"No second extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tChris Pratt\tis\tAmerican", (String)extraction.get().toString());
        extraction = this.mkExtraction(conll, 2);
        RelationTripleSegmenterTest.assertTrue((String)"No third extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tChris Pratt\tis\tactor", (String)extraction.get().toString());
    }

    public void testChrisManningOfStanford() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tChris\t2\tcompound\tNNP\tPERSON\n2\tManning\t0\troot\tNNP\tPERSON\n3\tof\t4\tcase\tIN\tO\n4\tStanford\t2\tnmod:of\tNNP\tORGANIZATION\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tChris Manning\tis of\tStanford", (String)extraction.get().toString());
    }

    public void testChrisManningOfStanfordLong() {
        String conll = "1\tChris\t2\tcompound\tNNP\tPERSON\n2\tManning\t5\tnsubj\tNNP\tPERSON\n3\tof\t4\tcase\tIN\tO\n4\tStanford\t2\tnmod:of\tNNP\tORGANIZATION\n5\tvisited\t0\troot\tVBD\tO\n6\tChina\t5\tdobj\tNNP\tLOCATION\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tChris Manning\tis of\tStanford", (String)extraction.get().toString());
    }

    public void testChrisIsOfStanford() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tChris\t2\tcompound\tNNP\tPERSON\n2\tManning\t0\troot\tNNP\tPERSON\n3\tof\t4\tcase\tIN\tO\n4\tStanford\t2\tnmod:of\tNNP\tORGANIZATION\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tChris Manning\tis of\tStanford", (String)extraction.get().toString());
    }

    public void testPPExtraction() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tObama\t0\troot\tNNP\tPERSON\n2\tin\t3\tcase\tIN\tO\n3\tTucson\t1\tnmod:in\tNNP\tLOCATION\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tObama\tis in\tTucson", (String)extraction.get().toString());
        extraction = this.mkExtraction("1\tPietro\t2\tcompound\tNNP\tPERSON\n2\tBadoglio\t0\troot\tNNP\tPERSON\n3\tin\t5\tcase\tIN\tO\n4\tsouthern\t5\tamod\tJJ\tO\n5\tItaly\t2\tnmod:in\tNN\tLOCATION\n");
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tPietro Badoglio\tis in\tItaly", (String)extraction.get().toString());
    }

    public void testCommaDoesntOvergenerate() {
        Optional<RelationTriple> extraction = this.mkExtraction("1\tHonolulu\t3\tcompound\tNNP\tLOCATION\n2\t,\t1\tpunct\t.\tO\n3\tHawaii\t0\troot\tNNP\tLOCATION\n");
        RelationTripleSegmenterTest.assertFalse((String)("Found extraction when we shouldn't have! Extraction: " + (extraction.isPresent() ? (Comparable)extraction.get() : "")), (boolean)extraction.isPresent());
        extraction = this.mkExtraction("1\tHonolulu\t3\tcompound\tNNP\tLOCATION\n2\t,\t1\tpunct\t.\tO\n3\tHawaii\t0\troot\tNNP\tLOCATION\n4\t,\t3\tpunct\t.\tO\n");
        RelationTripleSegmenterTest.assertFalse((String)("Found extraction when we shouldn't have! Extraction: " + (extraction.isPresent() ? (Comparable)extraction.get() : "")), (boolean)extraction.isPresent());
    }

    public void testCompoundPossessive() {
        String conll = "1\tIBM\t4\tnmod:poss\tNNP\tORGANIZATION\n2\t's\t1\tcase\tPOS\tO\n3\tCEO\t4\tcompound\tNNP\tTITLE\n4\tRometty\t0\troot\tNNP\tORGANIZATION\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, 1);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tRometty\tis\tCEO", (String)extraction.get().toString());
        extraction = this.mkExtraction(conll, 0);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tIBM\thas\tRometty", (String)extraction.get().toString());
        extraction = this.mkExtraction(conll, 2);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tRometty\tis CEO of\tIBM", (String)extraction.get().toString());
    }

    public void testAllNominals() {
        String conll = "1\tfierce\t2\tamod\tJJ\n2\tlions\t0\troot\tNN\n3\tin\t4\tcase\tIN\n4\tNarnia\t2\tnmod:in\tNNP\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, 0, true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tfierce lions\tis in\tNarnia", (String)extraction.get().toString());
        extraction = this.mkExtraction(conll, 1, true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tlions\tis\tfierce", (String)extraction.get().toString());
        extraction = this.mkExtraction(conll, 0, false);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tfierce lions\tis in\tNarnia", (String)extraction.get().toString());
        RelationTripleSegmenterTest.assertFalse((boolean)this.mkExtraction(conll, 1, false).isPresent());
    }

    public void testAcl() {
        String conll = "1\tman\t0\troot\tNN\n2\tsitting\t1\tacl\tVBG\n3\tin\t4\tcase\tIN\n4\ttree\t2\tnmod:in\tNN\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tman\tsitting in\ttree", (String)extraction.get().toString());
    }

    public void testAclWithAdverb() {
        String conll = "1\tman\t0\troot\tNN\n2\tsitting\t1\tacl\tVBG\n3\tvery\t2\tadvmod\tRB\n4\tquietly\t2\tadvmod\tRB\n5\tin\t6\tcase\tIN\n6\ttree\t2\tnmod:in\tNN\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tman\tsitting very quietly in\ttree", (String)extraction.get().toString());
    }

    public void testAclNoPP() {
        String conll = "1\tman\t0\troot\tNN\n2\triding\t1\tacl\tVBG\n3\thorse\t2\tdobj\tNN\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tman\triding\thorse", (String)extraction.get().toString());
    }

    public void testAclWithPP() {
        String conll = "1\tweeds\t0\troot\tNN\n2\tgrowing\t1\tacl\tVBG\n3\taround\t4\tcase\tIN\n4\tplant\t2\tnmod:around\tNN\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tweeds\tgrowing around\tplant", (String)extraction.get().toString());
    }

    public void testNmodTmod() {
        String conll = "1\tFriday\t3\tnmod:tmod\tNN\n2\tI\t3\tnsubj\tPR\n3\tmake\t0\troot\tVB\n4\ttea\t3\tdobj\tNN\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tI\tmake tea at_time\tFriday", (String)extraction.get().toString());
    }

    public void testVPOnlyReplacedWith() {
        String conll = "1\treplaced\t0\tconj:and\tVBD\n2\twith\t5\tcase\tIN\n3\ta\t5\tdet\tDT\n4\tdifferent\t5\tamod\tJJ\n5\ttype\t1\tnmod:with\tNN\n6\tof\t7\tcase\tIN\n7\tfilter\t5\tnmod:of\tNN\n";
        boolean matches = false;
        SemanticGraph tree = (SemanticGraph)this.mkTree((String)conll).first;
        for (SemgrexPattern candidate : new RelationTripleSegmenter().VP_PATTERNS) {
            if (!candidate.matcher(tree).matches()) continue;
            matches = true;
        }
        RelationTripleSegmenterTest.assertTrue((boolean)matches);
    }

    public void testThrowAway() {
        String conll = "1\tI\t2\tnsubj\tPRP\n2\tthrow\t0\troot\tVB\n3\taway\t2\tcompound:ptr\tRP\n4\tmy\t5\tnmod:poss\tPRP$\n5\tlaptop\t2\tdobj\tNN\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tI\tthrow away\tmy laptop", (String)extraction.get().toString());
    }

    public void testMassOfIron() {
        String conll = "1\tmass\t5\tnsubj\tNN\n2\tof\t3\tcase\tIN\n3\tiron\t1\tnmod:of\tNN\n4\tis\t5\tcop\tVBZ\n5\t55amu\t0\troot\tNN\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, true);
        RelationTripleSegmenterTest.assertTrue((String)"No extraction for sentence!", (boolean)extraction.isPresent());
        RelationTripleSegmenterTest.assertEquals((String)"1.0\tiron\tmass of is\t55amu", (String)extraction.get().toString());
    }

    public void testStateOfTheUnion() {
        String conll = "1\tState\t5\tnsubj\tNNP\n2\tof\t3\tcase\tIN\n3\tUnion\t1\tnmod:of\tNNP\n4\tis\t5\tcop\tVBZ\n5\ttomorrow\t0\troot\tNN\n";
        Optional<RelationTriple> extraction = this.mkExtraction(conll, true);
        RelationTripleSegmenterTest.assertFalse((String)("Extraction found when we shouldn't have: " + extraction), (boolean)extraction.isPresent());
    }
}

