/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.naturalli.ClauseSplitter;
import edu.stanford.nlp.naturalli.ClauseSplitterSearchProblem;
import edu.stanford.nlp.naturalli.SentenceFragment;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.trees.GrammaticalRelation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;

public class OpenIETest {
    protected CoreLabel mkWord(String gloss, int index) {
        CoreLabel w = new CoreLabel();
        w.setWord(gloss);
        w.setValue(gloss);
        if (index >= 0) {
            w.setIndex(index);
        }
        return w;
    }

    protected Set<String> clauses(String conll) {
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        SemanticGraph tree = new SemanticGraph();
        for (String line : conll.split("\n")) {
            if (line.trim().equals("")) continue;
            String[] fields = line.trim().split("\\s+");
            int index = Integer.parseInt(fields[0]);
            String word = fields[1];
            CoreLabel label = this.mkWord(word, index);
            sentence.add(label);
            if (fields[2].equals("0")) {
                tree.addRoot(new IndexedWord(label));
            } else {
                tree.addVertex(new IndexedWord(label));
            }
            if (fields.length > 4) {
                label.setTag(fields[4]);
            }
            if (fields.length > 5) {
                label.setNER(fields[5]);
            }
            if (fields.length <= 6) continue;
            label.setLemma(fields[6]);
        }
        int i = 0;
        for (String line : conll.split("\n")) {
            if (line.trim().equals("")) continue;
            String[] fields = line.trim().split("\\s+");
            int parent = Integer.parseInt(fields[2]);
            String reln = fields[3];
            if (parent > 0) {
                tree.addEdge(new IndexedWord((CoreLabel)sentence.get(parent - 1)), new IndexedWord((CoreLabel)sentence.get(i)), new GrammaticalRelation(Language.English, reln, null, null), 1.0, false);
            }
            ++i;
        }
        ClauseSplitterSearchProblem problem = new ClauseSplitterSearchProblem(tree, true);
        HashSet<String> clauses = new HashSet<String>();
        problem.search(triple -> {
            clauses.add(((SentenceFragment)((Supplier)triple.third).get()).toString());
            return true;
        }, new LinearClassifier<ClauseSplitter.ClauseClassifierLabel, String>(new ClassicCounter()), ClauseSplitterSearchProblem.HARD_SPLITS, triple -> new ClassicCounter<String>(){
            {
                this.setCount("__undocumented_junit_no_classifier", 1.0);
            }
        }, 100000);
        return clauses;
    }

    @Test
    public void testNoClauses() {
        Assert.assertEquals((Object)new HashSet<String>(){
            {
                this.add("cats have tails");
            }
        }, this.clauses("1\tcats\t2\tnsubj\tNN\n2\thave\t0\troot\tVB\n3\ttails\t2\tdobj\tNN\n"));
    }

    @Test
    public void testXCompObj() {
        Assert.assertEquals((Object)new HashSet<String>(){
            {
                this.add("I persuaded Fred to leave the room");
                this.add("Fred leave the room");
            }
        }, this.clauses("1\tI\t2\tnsubj\tPR\n2\tpersuaded\t0\troot\tVBD\n3\tFred\t2\tdobj\tNNP\n4\tto\t5\taux\tTO\n5\tleave\t2\txcomp\tVB\n6\tthe\t7\tdet\tDT\n7\troom\t5\tdobj\tNN\n"));
    }

    @Test
    public void testXCompSubj() {
        Assert.assertEquals((Object)new HashSet<String>(){
            {
                this.add("I was persuaded to leave the room");
                this.add("I leave the room");
            }
        }, this.clauses("1\tI\t3\tnsubjpass\tPR\n2\twas\t3\tauxpass\tVB\n3\tpersuaded\t0\troot\tVBD\n4\tto\t5\taux\tTO\n5\tleave\t3\txcomp\tVB\n6\tthe\t7\tdet\tDT\n7\troom\t5\tdobj\tNN\n"));
    }

    @Test
    public void testCComp() {
        Assert.assertEquals((Object)new HashSet<String>(){
            {
                this.add("I suggested that he leave the room");
                this.add("he leave the room");
            }
        }, this.clauses("1\tI\t2\tnsubj\tPR\n2\tsuggested\t0\troot\tVBD\n3\tthat\t5\tmark\tIN\n4\the\t5\tnsubj\tPR\n5\tleave\t2\tccomp\tVB\n6\tthe\t7\tdet\tDT\n7\troom\t5\tdobj\tNN\n"));
    }
}

