/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Lazy;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class NaturalLogicAnnotatorITest {
    private static Lazy<StanfordCoreNLP> pipeline = Lazy.of(() -> new StanfordCoreNLP(new Properties(){
        {
            this.setProperty("annotators", "tokenize,ssplit,pos,lemma,depparse,natlog");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "en");
            this.setProperty("enforceRequirements", "false");
        }
    }));

    @Test
    public void testAnnotatorRuns() {
        Annotation ann = new Annotation("All cats have tails");
        pipeline.get().annotate(ann);
        List tokens = (List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0)).get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertTrue((boolean)((CoreLabel)tokens.get(0)).containsKey(NaturalLogicAnnotations.OperatorAnnotation.class));
        Assert.assertTrue((boolean)((Polarity)((CoreLabel)tokens.get(0)).get(NaturalLogicAnnotations.PolarityAnnotation.class)).isUpwards());
        Assert.assertTrue((boolean)((Polarity)((CoreLabel)tokens.get(1)).get(NaturalLogicAnnotations.PolarityAnnotation.class)).isDownwards());
        Assert.assertTrue((boolean)((Polarity)((CoreLabel)tokens.get(2)).get(NaturalLogicAnnotations.PolarityAnnotation.class)).isUpwards());
        Assert.assertTrue((boolean)((Polarity)((CoreLabel)tokens.get(3)).get(NaturalLogicAnnotations.PolarityAnnotation.class)).isUpwards());
    }
}

