/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.benchmarks;

import edu.stanford.nlp.loglinear.model.ConcatVector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;

public class ConcatVectorBenchmark {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        int i;
        int i2;
        long randomSeed = 10101L;
        ConcatVectorConstructionRecord[] randomSizedRecords = new ConcatVectorConstructionRecord[100000];
        Random r = new Random(randomSeed);
        for (int i3 = 0; i3 < randomSizedRecords.length; ++i3) {
            randomSizedRecords[i3] = new ConcatVectorConstructionRecord(r);
        }
        int[] sizes = ConcatVectorConstructionRecord.getRandomSizes(r);
        ConcatVectorConstructionRecord[] sameSizedRecords = new ConcatVectorConstructionRecord[100000];
        for (int i4 = 0; i4 < sameSizedRecords.length; ++i4) {
            sameSizedRecords[i4] = new ConcatVectorConstructionRecord(r, sizes);
        }
        ConcatVectorConstructionRecord toClone = new ConcatVectorConstructionRecord(r);
        System.out.println("Warming up");
        for (i2 = 0; i2 < 10; ++i2) {
            System.out.println(i2);
            System.out.println("Serialize");
            ConcatVectorBenchmark.protoSerializationBenchmark(randomSizedRecords);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            System.out.println(i2);
            System.out.println("Clone");
            ConcatVectorBenchmark.cloneBenchmark(toClone.create());
        }
        for (i2 = 0; i2 < 100; ++i2) {
            System.out.println(i2);
            System.out.println("Construction");
            ConcatVectorBenchmark.constructionBenchmark(randomSizedRecords);
        }
        for (i2 = 0; i2 < 100; ++i2) {
            System.out.println(i2);
            System.out.println("Inner Product");
            ConcatVectorBenchmark.dotProductBenchmark(sameSizedRecords);
        }
        for (i2 = 0; i2 < 100; ++i2) {
            System.out.println(i2);
            System.out.println("Addition");
            ConcatVectorBenchmark.addBenchmark(sameSizedRecords);
        }
        System.out.println("Done warmup");
        long cloneRuntime = 0L;
        long constructionRuntime = 0L;
        long dotProductRuntime = 0L;
        long addRuntime = 0L;
        long protoSerializeRuntime = 0L;
        long protoSerializeSize = 0L;
        for (i = 0; i < 10; ++i) {
            System.out.println(i);
            System.out.println("Serialize");
            SerializationReport sr = ConcatVectorBenchmark.protoSerializationBenchmark(randomSizedRecords);
            protoSerializeRuntime += sr.time;
            if (protoSerializeSize != 0L) continue;
            protoSerializeSize = sr.size;
        }
        for (i = 0; i < 10; ++i) {
            System.out.println(i);
            System.out.println("Clone");
            cloneRuntime += ConcatVectorBenchmark.cloneBenchmark(toClone.create());
        }
        for (i = 0; i < 100; ++i) {
            System.out.println(i);
            System.out.println("Construction");
            constructionRuntime += ConcatVectorBenchmark.constructionBenchmark(randomSizedRecords);
        }
        for (i = 0; i < 100; ++i) {
            System.out.println(i);
            System.out.println("Inner Product");
            dotProductRuntime += ConcatVectorBenchmark.dotProductBenchmark(sameSizedRecords);
        }
        for (i = 0; i < 100; ++i) {
            System.out.println(i);
            System.out.println("Addition");
            addRuntime += ConcatVectorBenchmark.addBenchmark(sameSizedRecords);
        }
        System.out.println("Clone Runtime: " + cloneRuntime);
        System.out.println("Construction Runtime: " + constructionRuntime);
        System.out.println("Dot Product Runtimes: " + dotProductRuntime);
        System.out.println("Add Runtimes: " + addRuntime);
        System.out.println("Proto Serialize Runtimes: " + protoSerializeRuntime);
        System.out.println("Proto Serialize Size: " + protoSerializeSize);
    }

    static long cloneBenchmark(ConcatVector vector) {
        long before = System.currentTimeMillis();
        for (int i = 0; i < 10000000; ++i) {
            vector.deepClone();
        }
        return System.currentTimeMillis() - before;
    }

    static ConcatVector[] makeVectors(ConcatVectorConstructionRecord[] records) {
        ConcatVector[] vectors = new ConcatVector[records.length];
        for (int i = 0; i < records.length; ++i) {
            vectors[i] = records[i].create();
        }
        return vectors;
    }

    static long addBenchmark(ConcatVectorConstructionRecord[] records) {
        ConcatVector[] vectors = ConcatVectorBenchmark.makeVectors(records);
        long before = System.currentTimeMillis();
        for (int i = 1; i < vectors.length; ++i) {
            vectors[0].addVectorInPlace(vectors[i], 1.0);
        }
        return System.currentTimeMillis() - before;
    }

    static long dotProductBenchmark(ConcatVectorConstructionRecord[] records) {
        ConcatVector[] vectors = ConcatVectorBenchmark.makeVectors(records);
        long before = System.currentTimeMillis();
        for (int i = 0; i < vectors.length; ++i) {
            vectors[0].dotProduct(vectors[i]);
        }
        return System.currentTimeMillis() - before;
    }

    static long constructionBenchmark(ConcatVectorConstructionRecord[] records) {
        long before = System.currentTimeMillis();
        for (int i = 0; i < records.length; ++i) {
            ConcatVector concatVector = records[i].create();
        }
        return System.currentTimeMillis() - before;
    }

    static SerializationReport protoSerializationBenchmark(ConcatVectorConstructionRecord[] records) throws IOException, ClassNotFoundException {
        ConcatVector[] vectors = ConcatVectorBenchmark.makeVectors(records);
        ByteArrayOutputStream bArr = new ByteArrayOutputStream();
        long before = System.currentTimeMillis();
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i].writeToStream(bArr);
        }
        bArr.close();
        byte[] bytes = bArr.toByteArray();
        ByteArrayInputStream bArrIn = new ByteArrayInputStream(bytes);
        for (int i = 0; i < vectors.length; ++i) {
            ConcatVector.readFromStream(bArrIn);
        }
        SerializationReport sr = new SerializationReport();
        sr.time = System.currentTimeMillis() - before;
        sr.size = bytes.length;
        return sr;
    }

    static class SerializationReport {
        public long time;
        public int size;

        SerializationReport() {
        }
    }

    public static class ConcatVectorConstructionRecord {
        int[] componentSizes;
        double[][] densePieces;
        int[] sparseOffsets;
        double[] sparseValues;

        public static int[] getRandomSizes(Random r) {
            int length = r.nextInt(10);
            int[] sizes = new int[length];
            for (int i = 0; i < length; ++i) {
                boolean sparse = r.nextBoolean();
                sizes[i] = sparse ? -1 : r.nextInt(100);
            }
            return sizes;
        }

        public ConcatVectorConstructionRecord(Random r) {
            this(r, ConcatVectorConstructionRecord.getRandomSizes(r));
        }

        public ConcatVectorConstructionRecord(Random r, int[] sizes) {
            int length = sizes.length;
            this.componentSizes = sizes;
            this.densePieces = new double[length][];
            this.sparseOffsets = new int[length];
            this.sparseValues = new double[length];
            for (int i = 0; i < length; ++i) {
                boolean sparse;
                boolean bl = sparse = this.componentSizes[i] == -1;
                if (sparse) {
                    this.sparseOffsets[i] = r.nextInt(100);
                    this.sparseValues[i] = r.nextFloat();
                    continue;
                }
                this.densePieces[i] = new double[this.componentSizes[i]];
                for (int j = 0; j < this.densePieces[i].length; ++j) {
                    this.densePieces[i][j] = r.nextFloat();
                }
            }
        }

        public ConcatVector create() {
            ConcatVector mv = new ConcatVector(this.componentSizes.length);
            for (int i = 0; i < this.componentSizes.length; ++i) {
                if (this.componentSizes[i] == -1) {
                    mv.setSparseComponent(i, this.sparseOffsets[i], this.sparseValues[i]);
                    continue;
                }
                mv.setDenseComponent(i, this.densePieces[i]);
            }
            return mv;
        }
    }
}

