/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.spanish.scripts;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.international.spanish.SpanishTreeReaderFactory;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;

public class TreeToTSV {
    private static Redwood.RedwoodChannels log = Redwood.channels(TreeToTSV.class);

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.printf("Usage: java %s tree_file%n", TreeToTSV.class.getName());
            System.exit(-1);
        }
        String treeFile = args[0];
        try {
            Tree tree;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(treeFile), "UTF-8"));
            SpanishTreeReaderFactory trf = new SpanishTreeReaderFactory();
            TreeReader tr = trf.newTreeReader(br);
            StringBuilder sb = new StringBuilder();
            String nl = System.getProperty("line.separator");
            Pattern nePattern = Pattern.compile("^grup\\.nom\\.");
            Pattern npPattern = Pattern.compile("^np0000.$");
            while ((tree = tr.readTree()) != null) {
                for (Tree t : tree) {
                    if (!t.isPreTerminal()) continue;
                    int type = 79;
                    Tree grandma = t.ancestor(1, tree);
                    String grandmaValue = ((CoreLabel)grandma.label()).value();
                    if (nePattern.matcher(grandmaValue).find()) {
                        type = grandmaValue.charAt(9);
                    } else {
                        String pos = ((CoreLabel)t.label()).value();
                        if (npPattern.matcher(pos).find()) {
                            type = pos.charAt(6);
                        }
                    }
                    Tree wordNode = t.firstChild();
                    String word = ((CoreLabel)wordNode.label()).value();
                    sb.append(word).append("\t");
                    switch (type) {
                        case 112: {
                            sb.append("PERS");
                            break;
                        }
                        case 108: {
                            sb.append("LUG");
                            break;
                        }
                        case 111: {
                            sb.append("ORG");
                            break;
                        }
                        case 48: {
                            sb.append("OTROS");
                            break;
                        }
                        default: {
                            sb.append("O");
                        }
                    }
                    sb.append(nl);
                }
                sb.append(nl);
            }
            System.out.print(sb.toString());
            tr.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

