/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.spanish;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class SpanishTokenizerAnnotatorITest
extends TestCase {
    private static List<String> spanishTokens = Arrays.asList("Da", "me", "lo");

    public void testSpanish() {
        Annotation ann = new Annotation("Damelo");
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize");
        props.setProperty("tokenize.language", "es");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(ann);
        Iterator<String> it = spanishTokens.iterator();
        for (CoreLabel word : (List)ann.get(CoreAnnotations.TokensAnnotation.class)) {
            SpanishTokenizerAnnotatorITest.assertEquals((String)"Bung token in new CoreLabel usage", (String)it.next(), (String)((String)word.get(CoreAnnotations.TextAnnotation.class)));
        }
        SpanishTokenizerAnnotatorITest.assertFalse((String)"Too few tokens in new CoreLabel usage", (boolean)it.hasNext());
    }
}

