/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.pipeline;

import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.international.arabic.ArabicTreeReaderFactory;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MWETreeVisitorExternal
implements TreeVisitor {
    private static Redwood.RedwoodChannels log = Redwood.channels(MWETreeVisitorExternal.class);
    private static final String mweFile = "/home/rayder441/sandbox/javanlp/projects/core/data/edu/stanford/nlp/pipeline/attia-mwe-list.txt.out.tok.fixed.proc.uniq";
    private final Set<String> mweDictionary = this.loadMWEs();

    private Set<String> loadMWEs() {
        Set<String> mweSet = Generics.newHashSet();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mweFile), "UTF-8"));
            while ((line = br.readLine()) != null) {
                mweSet.add(line.trim());
            }
            br.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mweSet;
    }

    @Override
    public void visitTree(Tree tree) {
        if (tree == null) {
            return;
        }
        String yield = SentenceUtils.listToString(tree.yield());
        if (this.mweDictionary.contains(yield)) {
            List<Tree> children = this.getPreterminalSubtrees(tree);
            String newLabel = "MW" + tree.value();
            tree.setValue(newLabel);
            tree.setChildren(children);
            return;
        }
        for (Tree subTree : tree.children()) {
            if (!subTree.isPhrasal()) continue;
            this.visitTree(subTree);
        }
    }

    private List<Tree> getPreterminalSubtrees(Tree tree) {
        ArrayList<Tree> preterminals = new ArrayList<Tree>();
        for (Tree subTree : tree) {
            if (!subTree.isPreTerminal()) continue;
            preterminals.add(subTree);
        }
        return preterminals;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.printf("Usage: java %s atb_tree_file > atb_tree_file.out%n", MWETreeVisitorExternal.class.getName());
            System.exit(-1);
        }
        ArabicTreeReaderFactory trf = new ArabicTreeReaderFactory();
        try {
            Tree tree;
            TreeReader tr = trf.newTreeReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), "UTF-8")));
            MWETreeVisitorExternal visitor = new MWETreeVisitorExternal();
            int treeId = 0;
            while ((tree = tr.readTree()) != null) {
                if (tree.value().equals("ROOT")) {
                    tree = tree.firstChild();
                }
                visitor.visitTree(tree);
                System.out.println(tree.toString());
                ++treeId;
            }
            tr.close();
            System.err.printf("Processed %d trees.%n", treeId);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

