/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.qe;

import edu.stanford.nlp.ie.qe.QuantifiableEntityExtractor;
import edu.stanford.nlp.ie.qe.SimpleQuantifiableEntity;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import java.util.List;
import junit.framework.TestCase;

public class QuantifiableEntityExtractorITest
extends TestCase {
    private static AnnotationPipeline pipeline;
    private static QuantifiableEntityExtractor extractor;

    public void test() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        super.setUp();
        Class<QuantifiableEntityExtractorITest> clazz = QuantifiableEntityExtractorITest.class;
        synchronized (QuantifiableEntityExtractorITest.class) {
            if (pipeline == null) {
                pipeline = new AnnotationPipeline();
                pipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
                pipeline.addAnnotator(new WordsToSentencesAnnotator(false));
                pipeline.addAnnotator(new POSTaggerAnnotator("edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger", false));
            }
            extractor = new QuantifiableEntityExtractor();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static Annotation createDocument(String text) {
        Annotation annotation = new Annotation(text);
        pipeline.annotate(annotation);
        return annotation;
    }

    private static void runAndCheck(String prefix, String[] sentences, ExpectedQuantity[][] expected) {
        for (int si = 0; si < sentences.length; ++si) {
            String sentence = sentences[si];
            Annotation annotation = QuantifiableEntityExtractorITest.createDocument(sentence);
            List<MatchedExpression> matchedExpressions = extractor.extract(annotation);
            if (expected == null) {
                for (MatchedExpression matchedExpression : matchedExpressions) {
                    String text = matchedExpression.getText();
                    Value value = matchedExpression.getValue();
                    System.out.println(prefix + ": Got expression " + text + " with value " + value);
                }
                QuantifiableEntityExtractorITest.fail((String)(prefix + ": No expected provided"));
                continue;
            }
            int minMatchable = Math.min(expected[si].length, matchedExpressions.size());
            for (int i = 0; i < minMatchable; ++i) {
                ExpectedQuantity expectedQuantity = expected[si][i];
                MatchedExpression matched = matchedExpressions.get(i);
                SimpleQuantifiableEntity actualQuantity = (SimpleQuantifiableEntity)matched.getValue().get();
                QuantifiableEntityExtractorITest.assertEquals((String)(prefix + ".matched." + si + "." + i + ".text"), (String)expectedQuantity.text, (String)matched.getText());
                QuantifiableEntityExtractorITest.assertEquals((String)(prefix + ".matched." + si + "." + i + ".normalizedValue"), (String)expectedQuantity.normalizedValue, (String)actualQuantity.toString());
                QuantifiableEntityExtractorITest.assertEquals((String)(prefix + ".matched." + si + "." + i + ".type"), (String)expectedQuantity.type, (String)actualQuantity.getUnit().type);
            }
            QuantifiableEntityExtractorITest.assertEquals((String)(prefix + ".length." + si), (int)expected[si].length, (int)matchedExpressions.size());
        }
    }

    public static void _testMoney() throws Exception {
        String[] sentences = new String[]{"I have 1 dollar and 2 cents.", "It cost 10 thousand million dollars."};
        ExpectedQuantity[][] expected = new ExpectedQuantity[][]{{new ExpectedQuantity("1 dollar", "$1.00", "MONEY"), new ExpectedQuantity("2 cents", "$0.02", "MONEY")}, {new ExpectedQuantity("10 thousand million dollars", "$10000000000.00", "MONEY")}};
        QuantifiableEntityExtractorITest.runAndCheck("testMoney", sentences, expected);
    }

    public static void _testLength() {
        String[] sentences = new String[]{"We are 2 kilometer away.", "We are 2 kilometers away.", "We turn after 5 miles.", "The box is 100 centimeters tall.", "The box is 10cm wide.", "The box is over 1000 mm long.", "The box is 2ft long."};
        ExpectedQuantity[][] expected = new ExpectedQuantity[][]{{new ExpectedQuantity("2 kilometer", "2000.0m", "LENGTH")}, {new ExpectedQuantity("2 kilometers", "2000.0m", "LENGTH")}, {new ExpectedQuantity("5 miles", "5.0mi", "LENGTH")}, {new ExpectedQuantity("100 centimeters", "1.0m", "LENGTH")}, {new ExpectedQuantity("10cm", "0.1m", "LENGTH")}, {new ExpectedQuantity("1000 mm", "1.0m", "LENGTH")}, {new ExpectedQuantity("2ft", "2.0'", "LENGTH")}};
        QuantifiableEntityExtractorITest.runAndCheck("testLength", sentences, expected);
    }

    public static void _testWeight() {
        String[] sentences = new String[]{"The ball is 2 kilograms in weight.", "There are five grams.", "How much is seven pounds?"};
        ExpectedQuantity[][] expected = new ExpectedQuantity[][]{{new ExpectedQuantity("2 kilograms", "2.0kg", "WEIGHT")}, {new ExpectedQuantity("five grams", "0.005kg", "WEIGHT")}, {new ExpectedQuantity("seven pounds", "7.0lb", "WEIGHT")}};
        QuantifiableEntityExtractorITest.runAndCheck("testWeight", sentences, expected);
    }

    public static class ExpectedQuantity {
        String text;
        String normalizedValue;
        String type;

        public ExpectedQuantity(String text, String normalizedValue, String type) {
            this.text = text;
            this.normalizedValue = normalizedValue;
            this.type = type;
        }
    }
}

