/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.pascal;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Prior {
    private Map<String, Integer> fieldIndices;
    private String[] indexFields;
    private double[] matrix;

    public Prior(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            throw new IOException();
        }
        this.indexFields = line.split("\\s+");
        this.fieldIndices = new HashMap<String, Integer>();
        for (int i = 0; i < this.indexFields.length; ++i) {
            this.fieldIndices.put(this.indexFields[i], i);
        }
        if (this.indexFields.length < 1 || this.indexFields.length > 31) {
            throw new IOException("Invalid number of fields, should be >=1 and <= 31");
        }
        int matrixSize = 1 << this.indexFields.length;
        this.matrix = new double[matrixSize];
        int matrixIdx = 0;
        while (matrixIdx < this.matrix.length && (line = reader.readLine()) != null) {
            String[] tokens = line.split("\\s+");
            for (int t = 0; matrixIdx < this.matrix.length && t < tokens.length; ++t) {
                this.matrix[matrixIdx++] = Double.parseDouble(tokens[t]);
            }
        }
    }

    public double get(Set presentFields) {
        int index = 0;
        for (String field : this.indexFields) {
            index *= 2;
            if (!presentFields.contains(field)) continue;
            ++index;
        }
        return this.matrix[index];
    }

    public static void main(String[] args) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader("/tmp/acstats"));
        Prior p = new Prior(br);
        HashSet<String> hs = new HashSet<String>();
        hs.add("workshopname");
        double d = p.get(hs);
        System.out.println("d is " + d);
    }
}

