/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.structure;

import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.EventMention;
import edu.stanford.nlp.ie.machinereading.structure.ExtractionObject;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ie.machinereading.structure.RelationMentionFactory;
import edu.stanford.nlp.ling.Word;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ExtractionSentence
implements Serializable {
    private static final long serialVersionUID = 87958315651919036L;
    private final String documentId;
    private String textContent;
    private final List<RelationMention> relationMentions;
    private final List<EntityMention> entityMentions;
    private final List<EventMention> eventMentions;

    public ExtractionSentence(String docid, String textContent) {
        this.documentId = docid;
        this.textContent = textContent;
        this.entityMentions = new ArrayList<EntityMention>();
        this.relationMentions = new ArrayList<RelationMention>();
        this.eventMentions = new ArrayList<EventMention>();
    }

    public ExtractionSentence(ExtractionSentence original) {
        this.documentId = original.documentId;
        this.relationMentions = new ArrayList<RelationMention>(original.relationMentions);
        this.entityMentions = new ArrayList<EntityMention>(original.entityMentions);
        this.eventMentions = new ArrayList<EventMention>(original.eventMentions);
        this.textContent = original.textContent;
    }

    public void addEntityMention(EntityMention arg) {
        this.entityMentions.add(arg);
    }

    public void addEntityMentions(Collection<EntityMention> args) {
        this.entityMentions.addAll(args);
    }

    public void addRelationMention(RelationMention rel) {
        this.relationMentions.add(rel);
    }

    public List<RelationMention> getRelationMentions() {
        return Collections.unmodifiableList(this.relationMentions);
    }

    public void setRelationMentions(List<RelationMention> rels) {
        this.relationMentions.clear();
        this.relationMentions.addAll(rels);
    }

    public RelationMention getRelation(RelationMentionFactory factory, ExtractionObject ... args) {
        for (RelationMention rel : this.relationMentions) {
            if (!rel.argsMatch(args)) continue;
            return rel;
        }
        return RelationMention.createUnrelatedRelation(factory, args);
    }

    public List<RelationMention> getAllRelations(RelationMentionFactory factory) {
        ArrayList<RelationMention> allRelations = new ArrayList<RelationMention>(this.relationMentions);
        allRelations.addAll(this.getAllUnrelatedRelations(factory));
        return allRelations;
    }

    public List<RelationMention> getAllUnrelatedRelations(RelationMentionFactory factory) {
        ArrayList<RelationMention> nonRelations = new ArrayList<RelationMention>();
        ArrayList<RelationMention> allRelations = new ArrayList<RelationMention>(this.relationMentions);
        for (int i = 0; i < this.getEntityMentions().size(); ++i) {
            for (int j = 0; j < this.getEntityMentions().size(); ++j) {
                if (i == j) continue;
                EntityMention arg1 = this.getEntityMentions().get(i);
                EntityMention arg2 = this.getEntityMentions().get(j);
                boolean match = false;
                for (RelationMention rel : allRelations) {
                    if (!rel.argsMatch(arg1, arg2)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                RelationMention nonrel = RelationMention.createUnrelatedRelation(factory, arg1, arg2);
                nonRelations.add(nonrel);
                allRelations.add(nonrel);
            }
        }
        return nonRelations;
    }

    public void addEventMention(EventMention event) {
        this.eventMentions.add(event);
    }

    public List<EventMention> getEventMentions() {
        return Collections.unmodifiableList(this.eventMentions);
    }

    public void setEventMentions(List<EventMention> events) {
        this.eventMentions.clear();
        this.eventMentions.addAll(events);
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    public List<EntityMention> getEntityMentions() {
        return Collections.unmodifiableList(this.entityMentions);
    }

    public void setEntityMentions(List<EntityMention> newArgs) {
        this.entityMentions.clear();
        this.entityMentions.addAll(newArgs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("\"" + this.textContent + "\"");
        sb.append("\n");
        for (RelationMention rel : this.relationMentions) {
            sb.append("\n");
            sb.append(rel);
        }
        return sb.toString();
    }

    public static String tokensToString(Word[] tokens) {
        StringBuilder sb = new StringBuilder(512);
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            Word l = tokens[i];
            sb.append(l.word() + "{" + l.beginPosition() + ", " + l.endPosition() + "}");
        }
        return sb.toString();
    }

    public String getDocumentId() {
        return this.documentId;
    }
}

