/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading;

import edu.stanford.nlp.ie.machinereading.ResultsPrinter;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EntityExtractorResultsPrinter
extends ResultsPrinter {
    private static Redwood.RedwoodChannels log = Redwood.channels(EntityExtractorResultsPrinter.class);
    private Set<String> excludedClasses;
    private boolean useSubTypes;
    private boolean verbose;
    private boolean verboseInstances;
    private static final DecimalFormat FORMATTER = new DecimalFormat();

    public EntityExtractorResultsPrinter() {
        this(null, false);
    }

    protected EntityExtractorResultsPrinter(Set<String> excludedClasses, boolean useSubTypes) {
        this.excludedClasses = excludedClasses;
        this.useSubTypes = useSubTypes;
        this.verbose = true;
        this.verboseInstances = true;
    }

    @Override
    public void printResults(PrintWriter pw, List<CoreMap> goldStandard, List<CoreMap> extractorOutput) {
        ResultsPrinter.align(goldStandard, extractorOutput);
        ClassicCounter<String> correct = new ClassicCounter<String>();
        ClassicCounter<String> predicted = new ClassicCounter<String>();
        ClassicCounter<String> gold = new ClassicCounter<String>();
        for (int i = 0; i < goldStandard.size(); ++i) {
            String label;
            EntityMention m;
            Iterator m22;
            CoreMap goldSent = goldStandard.get(i);
            CoreMap sysSent = extractorOutput.get(i);
            String sysText = (String)sysSent.get(CoreAnnotations.TextAnnotation.class);
            String goldText = (String)goldSent.get(CoreAnnotations.TextAnnotation.class);
            if (this.verbose) {
                log.info("SCORING THE FOLLOWING SENTENCE:");
                log.info(sysSent.get(CoreAnnotations.TokensAnnotation.class));
            }
            HashSet<String> matchedGolds = new HashSet<String>();
            ArrayList goldEntities = (ArrayList)goldSent.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
            if (goldEntities == null) {
                goldEntities = new ArrayList();
            }
            for (Iterator m22 : goldEntities) {
                String label2 = this.makeLabel((EntityMention)((Object)m22));
                if (this.excludedClasses != null && this.excludedClasses.contains(label2)) continue;
                gold.incrementCount(label2);
            }
            List sysEntities = (List)sysSent.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
            if (sysEntities == null) {
                sysEntities = new ArrayList();
            }
            m22 = sysEntities.iterator();
            while (m22.hasNext()) {
                m = (EntityMention)m22.next();
                label = this.makeLabel(m);
                if (this.excludedClasses != null && this.excludedClasses.contains(label)) continue;
                predicted.incrementCount(label);
                if (this.verbose) {
                    log.info("COMPARING PREDICTED MENTION: " + m);
                }
                boolean found = false;
                for (EntityMention gm : goldEntities) {
                    if (matchedGolds.contains(gm.getObjectId())) continue;
                    if (this.verbose) {
                        log.info("\tagainst: " + gm);
                    }
                    if (!gm.equals(m, this.useSubTypes)) continue;
                    if (this.verbose) {
                        log.info("\t\t\tMATCH!");
                    }
                    found = true;
                    matchedGolds.add(gm.getObjectId());
                    if (!this.verboseInstances) break;
                    log.info("TRUE POSITIVE: " + m + " matched " + gm);
                    log.info("In sentence: " + sysText);
                    break;
                }
                if (found) {
                    correct.incrementCount(label);
                    continue;
                }
                if (!this.verboseInstances) continue;
                log.info("FALSE POSITIVE: " + m.toString());
                log.info("In sentence: " + sysText);
            }
            if (!this.verboseInstances) continue;
            m22 = goldEntities.iterator();
            while (m22.hasNext()) {
                m = (EntityMention)m22.next();
                label = this.makeLabel(m);
                if (matchedGolds.contains(m.getObjectId()) || this.excludedClasses != null && this.excludedClasses.contains(label)) continue;
                log.info("FALSE NEGATIVE: " + m.toString());
                log.info("In sentence: " + goldText);
            }
        }
        double totalCount = 0.0;
        double totalCorrect = 0.0;
        double totalPredicted = 0.0;
        pw.println("Label\tCorrect\tPredict\tActual\tPrecn\tRecall\tF");
        ArrayList labels = new ArrayList(gold.keySet());
        Collections.sort(labels);
        for (String label : labels) {
            if (this.excludedClasses != null && this.excludedClasses.contains(label)) continue;
            double numCorrect = correct.getCount(label);
            double numPredicted = predicted.getCount(label);
            double trueCount = gold.getCount(label);
            double precision = numPredicted > 0.0 ? numCorrect / numPredicted : 0.0;
            double recall = numCorrect / trueCount;
            double f = precision + recall > 0.0 ? 2.0 * precision * recall / (precision + recall) : 0.0;
            pw.println(StringUtils.padOrTrim(label, 21) + "\t" + numCorrect + "\t" + numPredicted + "\t" + trueCount + "\t" + FORMATTER.format(precision * 100.0) + "\t" + FORMATTER.format(100.0 * recall) + "\t" + FORMATTER.format(100.0 * f));
            totalCount += trueCount;
            totalCorrect += numCorrect;
            totalPredicted += numPredicted;
        }
        double precision = totalPredicted > 0.0 ? totalCorrect / totalPredicted : 0.0;
        double recall = totalCorrect / totalCount;
        double f = totalPredicted > 0.0 && totalCorrect > 0.0 ? 2.0 * precision * recall / (precision + recall) : 0.0;
        pw.println("Total\t" + totalCorrect + "\t" + totalPredicted + "\t" + totalCount + "\t" + FORMATTER.format(100.0 * precision) + "\t" + FORMATTER.format(100.0 * recall) + "\t" + FORMATTER.format(100.0 * f));
    }

    private String makeLabel(EntityMention m) {
        String label = m.getType();
        if (this.useSubTypes && m.getSubType() != null) {
            label = label + "-" + m.getSubType();
        }
        return label;
    }

    @Override
    public void printResultsUsingLabels(PrintWriter pw, List<String> goldStandard, List<String> extractorOutput) {
    }

    static {
        FORMATTER.setMaximumFractionDigits(1);
        FORMATTER.setMinimumFractionDigits(1);
    }
}

