/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Properties;

public class TestThreadedCRFClassifier {
    private static final int DEFAULT_SIM_THREADS = 3;
    private static final int DEFAULT_MULTIPLE_THREADS = 2;
    private final String inputEncoding;

    TestThreadedCRFClassifier(Properties props) {
        this.inputEncoding = props.getProperty("inputEncoding", "UTF-8");
    }

    static CRFClassifier loadClassifier(String loadPath, Properties props) {
        CRFClassifier crf = new CRFClassifier(props);
        crf.loadClassifierNoExceptions(loadPath, props);
        return crf;
    }

    String runClassifier(CRFClassifier crf, String testFile) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            crf.classifyAndWriteAnswers(testFile, output, crf.makeReaderAndWriter(), true);
            return output.toString(this.inputEncoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        try {
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
            System.setErr(new PrintStream((OutputStream)System.err, true, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        TestThreadedCRFClassifier.runTest(StringUtils.argsToProperties(args));
    }

    public static void runTest(Properties props) {
        TestThreadedCRFClassifier test = new TestThreadedCRFClassifier(props);
        test.runThreadedTest(props);
    }

    void runThreadedTest(Properties props) {
        int i;
        String testFile = props.getProperty("testFile");
        ArrayList<String> baseResults = new ArrayList<String>();
        ArrayList<String> modelNames = new ArrayList<String>();
        ArrayList<CRFClassifier> classifiers = new ArrayList<CRFClassifier>();
        int i2 = 1;
        while (props.getProperty("crf" + Integer.toString(i2)) != null) {
            String model = props.getProperty("crf" + Integer.toString(i2));
            CRFClassifier crf = TestThreadedCRFClassifier.loadClassifier(model, props);
            System.out.println("Loaded model " + model);
            modelNames.add(model);
            classifiers.add(crf);
            String results = this.runClassifier(crf, testFile);
            results = this.runClassifier(crf, testFile);
            baseResults.add(results);
            System.out.println("Stored base results for " + model + "; length " + results.length());
            ++i2;
        }
        for (i2 = 0; i2 < classifiers.size(); ++i2) {
            String repeated;
            CRFClassifier crf = (CRFClassifier)classifiers.get(i2);
            String model = (String)modelNames.get(i2);
            String base = (String)baseResults.get(i2);
            if (base.equals(repeated = this.runClassifier(crf, testFile))) continue;
            throw new RuntimeException("Repeated unthreaded results not the same for " + model + " run on file " + testFile);
        }
        int numThreads = PropertiesUtils.getInt(props, "simThreads", 3);
        ArrayList<CRFThread> threads = new ArrayList<CRFThread>();
        for (i = 0; i < numThreads; ++i) {
            threads.add(new CRFThread((CRFClassifier)classifiers.get(0), testFile, "Simultaneous-" + i));
        }
        for (i = 0; i < numThreads; ++i) {
            ((CRFThread)threads.get(i)).start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                ((CRFThread)threads.get(i)).join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (!((String)baseResults.get(0)).equals(((CRFThread)threads.get(i)).getResultsString())) {
                throw new RuntimeException("Results not equal when running " + (String)modelNames.get(0) + " under " + numThreads + " simultaneous threads");
            }
            System.out.println("Yay!");
        }
        if (classifiers.size() > 1) {
            numThreads = PropertiesUtils.getInt(props, "multipleThreads", 2);
            threads = new ArrayList();
            for (i = 0; i < numThreads * classifiers.size(); ++i) {
                int classifierNum = i % classifiers.size();
                int repeatNum = i / classifiers.size();
                threads.add(new CRFThread((CRFClassifier)classifiers.get(classifierNum), testFile, "Simultaneous-" + classifierNum + "-" + repeatNum));
            }
            for (CRFThread thread : threads) {
                thread.start();
            }
            for (int i3 = 0; i3 < threads.size(); ++i3) {
                int classifierNum = i3 % classifiers.size();
                int repeatNum = i3 / classifiers.size();
                try {
                    ((CRFThread)threads.get(i3)).join();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                String base = (String)baseResults.get(classifierNum);
                String threadResults = ((CRFThread)threads.get(i3)).getResultsString();
                if (!base.equals(threadResults)) {
                    throw new RuntimeException("Results not equal when running " + (String)modelNames.get(classifierNum) + " under " + numThreads + " threads with " + classifiers.size() + " total classifiers");
                }
                System.out.println("Yay!");
            }
        }
        System.out.println("Everything worked!");
    }

    class CRFThread
    extends Thread {
        private final CRFClassifier crf;
        private final String filename;
        private final String threadName;
        private String resultsString = "";

        public String getResultsString() {
            return this.resultsString;
        }

        CRFThread(CRFClassifier crf, String filename, String threadName) {
            this.crf = crf;
            this.filename = filename;
            this.threadName = threadName;
        }

        @Override
        public void run() {
            Timing t = new Timing();
            this.resultsString = TestThreadedCRFClassifier.this.runClassifier(this.crf, this.filename);
            long millis = t.stop();
            System.out.println("Thread " + this.threadName + " took " + millis + "ms to tag file " + this.filename);
        }
    }
}

