/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref.util;

import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConvertGenderFile {
    private ConvertGenderFile() {
    }

    public static void main(String[] args) throws IOException {
        String line;
        String input = null;
        String output = null;
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-input")) {
                input = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-output")) {
                output = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            throw new IllegalArgumentException("Unknown argument " + args[argIndex]);
        }
        if (input == null) {
            throw new IllegalArgumentException("Must specify input with -input");
        }
        if (output == null) {
            throw new IllegalArgumentException("Must specify output with -output");
        }
        Map<List<String>, Dictionaries.Gender> genderNumber = Generics.newHashMap();
        BufferedReader reader = IOUtils.readerFromString(input);
        while ((line = reader.readLine()) != null) {
            String[] split = line.split("\t");
            String[] countStr = split[1].split(" ");
            int male = Integer.parseInt(countStr[0]);
            int female = Integer.parseInt(countStr[1]);
            int neutral = Integer.parseInt(countStr[2]);
            Dictionaries.Gender gender = Dictionaries.Gender.UNKNOWN;
            if ((double)male * 0.5 > (double)(female + neutral) && male > 2) {
                gender = Dictionaries.Gender.MALE;
            } else if ((double)female * 0.5 > (double)(male + neutral) && female > 2) {
                gender = Dictionaries.Gender.FEMALE;
            } else if ((double)neutral * 0.5 > (double)(male + female) && neutral > 2) {
                gender = Dictionaries.Gender.NEUTRAL;
            }
            if (gender == Dictionaries.Gender.UNKNOWN) continue;
            String[] words = split[0].split(" ");
            List<String> tokens = Arrays.asList(words);
            genderNumber.put(tokens, gender);
        }
        IOUtils.writeObjectToFile(genderNumber, output);
    }
}

