/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LogisticClassifier;
import edu.stanford.nlp.classify.LogisticClassifierFactory;
import edu.stanford.nlp.dcoref.CoNLLMentionExtractor;
import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.Semantics;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SingletonPredictor {
    private static final Redwood.RedwoodChannels log = Redwood.channels(SingletonPredictor.class);

    private SingletonPredictor() {
    }

    private static void setTokenIndices(Document doc) {
        int token_index = 0;
        for (CoreMap sent : (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel token : (List)sent.get(CoreAnnotations.TokensAnnotation.class)) {
                token.set(CoreAnnotations.TokenBeginAnnotation.class, token_index++);
            }
        }
    }

    private static GeneralDataset<String, String> generateFeatureVectors(Properties props) throws Exception {
        Document document;
        Dataset<String, String> dataset = new Dataset<String, String>();
        Dictionaries dict = new Dictionaries(props);
        CoNLLMentionExtractor mentionExtractor = new CoNLLMentionExtractor(dict, props, new Semantics(dict));
        while ((document = ((MentionExtractor)mentionExtractor).nextDoc()) != null) {
            IndexedWord head;
            SingletonPredictor.setTokenIndices(document);
            document.extractGoldCorefClusters();
            Map<Integer, CorefCluster> entities = document.goldCorefClusters;
            for (CorefCluster entity : entities.values()) {
                for (Mention mention : entity.getCorefMentions()) {
                    if (mention.headWord.tag().startsWith("V") || (head = mention.dependency.getNodeByIndexSafe(mention.headWord.index())) == null) continue;
                    ArrayList<String> feats = mention.getSingletonFeatures(dict);
                    ((GeneralDataset)dataset).add(new BasicDatum<String, String>(feats, "1"));
                }
            }
            ArrayList<CoreLabel> gold_heads = new ArrayList<CoreLabel>();
            for (Mention gold_men : document.allGoldMentions.values()) {
                gold_heads.add(gold_men.headWord);
            }
            for (Mention predicted_men : document.allPredictedMentions.values()) {
                SemanticGraph dep = predicted_men.dependency;
                head = dep.getNodeByIndexSafe(predicted_men.headWord.index());
                if (head == null || predicted_men.headWord.tag().startsWith("V") || gold_heads.contains(predicted_men.headWord)) continue;
                ((GeneralDataset)dataset).add(new BasicDatum<String, String>(predicted_men.getSingletonFeatures(dict), "0"));
            }
        }
        ((GeneralDataset)dataset).summaryStatistics();
        return dataset;
    }

    public static LogisticClassifier<String, String> train(GeneralDataset<String, String> pDataset) {
        LogisticClassifierFactory lcf = new LogisticClassifierFactory();
        Classifier classifier = lcf.trainClassifier((GeneralDataset)pDataset);
        return classifier;
    }

    private static void saveToSerialized(LogisticClassifier<String, String> predictor, String filename) {
        try {
            log.info("Writing singleton predictor in serialized format to file " + filename + ' ');
            ObjectOutputStream out2 = IOUtils.writeStreamFromString(filename);
            out2.writeObject(predictor);
            out2.close();
            log.info("done.");
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public static void main(String[] args) throws Exception {
        Properties props = args.length > 0 ? StringUtils.argsToProperties(args) : new Properties();
        if (!props.containsKey("dcoref.conll2011")) {
            log.info("-dcoref.conll2011 [input_CoNLL_corpus]: was not specified");
            return;
        }
        if (!props.containsKey("singleton.predictor.output")) {
            log.info("-singleton.predictor.output [output_model_file]: was not specified");
            return;
        }
        GeneralDataset<String, String> data = SingletonPredictor.generateFeatureVectors(props);
        LogisticClassifier<String, String> classifier = SingletonPredictor.train(data);
        SingletonPredictor.saveToSerialized(classifier, props.getProperty("singleton.predictor.output"));
    }
}

