/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DcorefExactOutputITest {
    private static StanfordCoreNLP pipeline;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() {
        Class<DcorefExactOutputITest> clazz = DcorefExactOutputITest.class;
        synchronized (DcorefExactOutputITest.class) {
            if (pipeline == null) {
                Properties props = new Properties();
                props.setProperty("annotators", "tokenize, cleanxml, ssplit, pos, lemma, ner, parse, dcoref");
                pipeline = new StanfordCoreNLP(props);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static Map<Integer, List<ExpectedMention>> loadExpectedResults(String filename) {
        Map<Integer, List<ExpectedMention>> results = Generics.newHashMap();
        int id = -1;
        ArrayList<String> mentionLines = new ArrayList<String>();
        for (String line : IOUtils.readLines(filename)) {
            if (line.trim().isEmpty()) {
                if (mentionLines.isEmpty()) {
                    if (id == -1) continue;
                    throw new RuntimeException("Found coref chain without any mentions, id " + id);
                }
                ArrayList<ExpectedMention> mentions = new ArrayList<ExpectedMention>();
                for (String mentionLine : mentionLines) {
                    mentions.add(new ExpectedMention(mentionLine));
                }
                results.put(id, mentions);
                id = -1;
                mentionLines.clear();
                continue;
            }
            if (id == -1) {
                id = Integer.parseInt(line);
                continue;
            }
            mentionLines.add(line.trim());
        }
        return results;
    }

    private static void saveResults(String filename, Map<Integer, CorefChain> chains) throws IOException {
        FileWriter fout = new FileWriter(filename);
        BufferedWriter bout = new BufferedWriter(fout);
        ArrayList<Integer> keys = new ArrayList<Integer>(chains.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            DcorefExactOutputITest.saveKey(bout, key, chains.get(key));
        }
        bout.flush();
        bout.close();
        fout.close();
    }

    private static void saveKey(BufferedWriter bout, Integer key, CorefChain chain) throws IOException {
        bout.write(key.toString());
        bout.newLine();
        for (CorefChain.CorefMention mention : chain.getMentionsInTextualOrder()) {
            bout.write(mention.sentNum + " " + mention.mentionSpan);
            bout.newLine();
        }
        bout.newLine();
    }

    private static boolean compareChain(List<ExpectedMention> expectedChain, CorefChain chain) {
        for (ExpectedMention expectedMention : expectedChain) {
            boolean found = false;
            for (CorefChain.CorefMention mention : chain.getMentionsInTextualOrder()) {
                if (mention.sentNum != expectedMention.sentNum || !mention.mentionSpan.equals(expectedMention.mentionSpan)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static void compareResults(Map<Integer, List<ExpectedMention>> expected, Map<Integer, CorefChain> chains) {
        boolean found;
        Assert.assertEquals((String)"Unexpected difference in number of chains", (long)expected.size(), (long)chains.size());
        for (Map.Entry<Integer, List<ExpectedMention>> entry : expected.entrySet()) {
            found = false;
            List<ExpectedMention> expectedChain = entry.getValue();
            for (CorefChain corefChain : chains.values()) {
                if (!DcorefExactOutputITest.compareChain(expectedChain, corefChain)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Could not find expected coref chain " + entry.getKey() + ' ' + expectedChain + " in the results"), (boolean)found);
        }
        for (Map.Entry<Integer, Object> entry : chains.entrySet()) {
            found = false;
            CorefChain chain = (CorefChain)entry.getValue();
            for (List list : expected.values()) {
                if (!DcorefExactOutputITest.compareChain(list, chain)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Dcoref produced chain " + chain + " which was not in the expected results"), (boolean)found);
        }
    }

    @Test
    public void testCoref() throws IOException {
        String doc = IOUtils.slurpFile("edu/stanford/nlp/dcoref/STILLALONEWOLF_20050102.1100.eng.LDC2005E83.sgm");
        Annotation annotation = pipeline.process(doc);
        Map chains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        Map<Integer, List<ExpectedMention>> expected = DcorefExactOutputITest.loadExpectedResults("edu/stanford/nlp/dcoref/STILLALONEWOLF_20050102.1100.eng.LDC2005E83.expectedcoref");
        DcorefExactOutputITest.compareResults(expected, chains);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Expected args <input> <output>");
            throw new IllegalArgumentException();
        }
        String input = args[0];
        String output = args[1];
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, cleanxml, ssplit, pos, lemma, ner, parse, dcoref");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        String doc = IOUtils.slurpFile(input);
        Annotation annotation = pipeline.process(doc);
        Map chains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        DcorefExactOutputITest.saveResults(output, chains);
    }

    private static class ExpectedMention {
        int sentNum;
        String mentionSpan;

        ExpectedMention(String line) {
            String[] pieces = line.trim().split(" +", 2);
            this.sentNum = Integer.valueOf(pieces[0]);
            this.mentionSpan = pieces[1];
        }

        public String toString() {
            return this.sentNum + ": " + this.mentionSpan;
        }
    }
}

