/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.hybrid.rf;

import edu.stanford.nlp.coref.hybrid.rf.DecisionTree;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Index;
import java.io.Serializable;

public class RandomForest
implements Serializable {
    private static final long serialVersionUID = -2736377471905671276L;
    public final DecisionTree[] trees;
    public final Index<String> featureIndex;

    public RandomForest(Index<String> featureIndex, int numTrees) {
        this.featureIndex = featureIndex;
        this.trees = new DecisionTree[numTrees];
    }

    public double probabilityOfTrue(RVFDatum<Boolean, String> datum) {
        return this.probabilityOfTrue(datum.asFeaturesCounter());
    }

    public double probabilityOfTrue(Counter<String> features) {
        double probTrue = 0.0;
        for (DecisionTree tree : this.trees) {
            probTrue += tree.probabilityOfTrue(features);
        }
        return probTrue / (double)this.trees.length;
    }
}

