/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref;

import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.CorefScorer;
import edu.stanford.nlp.coref.CorefSystem;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Properties;
import junit.framework.TestCase;

public class CorefBenchmark
extends TestCase {
    public static CorefSystem corefSystem;
    public static Properties props;
    public static File WORK_DIR_FILE;
    protected static Redwood.RedwoodChannels logger;
    public double EXPECTED_F1_SCORE;
    public String PROPERTIES_PATH;
    public String WORK_DIR_NAME;
    public String testName;

    public void setUp() throws Exception, IOException {
        WORK_DIR_FILE = File.createTempFile(this.WORK_DIR_NAME, "");
        if (!WORK_DIR_FILE.delete() || !WORK_DIR_FILE.mkdir()) {
            throw new RuntimeIOException("Couldn't create temp directory " + WORK_DIR_FILE);
        }
        WORK_DIR_FILE.delete();
        WORK_DIR_FILE.mkdir();
        WORK_DIR_FILE.deleteOnExit();
        String[] corefArgs = new String[]{"-props", this.PROPERTIES_PATH};
        props = StringUtils.argsToProperties(corefArgs);
        props.setProperty("coref.conllOutputPath", WORK_DIR_FILE.getAbsolutePath() + "/");
        corefSystem = new CorefSystem(props);
    }

    public void testCoref() throws Exception {
        corefSystem.runOnConll(props);
        double finalConllScore = CorefScorer.getFinalConllScoreFromOutputDir(WORK_DIR_FILE.getAbsolutePath() + "/", CorefProperties.getScorerPath(props));
        logger.log("---");
        logger.log(this.testName);
        logger.log("Final conll score ((muc+bcub+ceafe)/3) = " + new DecimalFormat("#.##").format(finalConllScore));
        CorefBenchmark.assertTrue((String)("CoNLL score below threshold: " + finalConllScore + " < " + this.EXPECTED_F1_SCORE), (finalConllScore >= this.EXPECTED_F1_SCORE ? 1 : 0) != 0);
    }
}

