/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.benchmarks;

import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.classify.RVFDataset;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.optimization.SGDMinimizer;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Factory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;

public class Benchmarks {
    public static void benchmarkRVFLogisticRegression() {
        RVFDataset data = new RVFDataset();
        for (int i = 0; i < 10000; ++i) {
            Random r = new Random(42L);
            ClassicCounter<String> features = new ClassicCounter<String>();
            boolean cl = r.nextBoolean();
            for (int j = 0; j < 1000; ++j) {
                double value = cl && i % 2 == 0 ? r.nextDouble() * 2.0 - 0.6 : r.nextDouble() * 2.0 - 1.4;
                features.incrementCount("f" + j, value);
            }
            data.add(new RVFDatum(features, "target:" + cl));
        }
        LinearClassifierFactory factory = new LinearClassifierFactory();
        long msStart = System.currentTimeMillis();
        factory.trainClassifier((GeneralDataset)data);
        long delay = System.currentTimeMillis() - msStart;
        System.out.println("Training took " + delay + " ms");
    }

    public static void benchmarkLogisticRegression() {
        Dataset data = new Dataset();
        for (int i = 0; i < 10000; ++i) {
            Random r = new Random(42L);
            HashSet<String> features = new HashSet<String>();
            boolean cl = r.nextBoolean();
            for (int j = 0; j < 1000; ++j) {
                if (cl && i % 2 == 0) {
                    if (r.nextDouble() > 0.3) {
                        features.add("f:" + j + ":true");
                        continue;
                    }
                    features.add("f:" + j + ":false");
                    continue;
                }
                if (r.nextDouble() > 0.3) {
                    features.add("f:" + j + ":false");
                    continue;
                }
                features.add("f:" + j + ":false");
            }
            data.add(new BasicDatum(features, "target:" + cl));
        }
        LinearClassifierFactory factory = new LinearClassifierFactory();
        long msStart = System.currentTimeMillis();
        factory.trainClassifier((GeneralDataset)data);
        long delay = System.currentTimeMillis() - msStart;
        System.out.println("Training took " + delay + " ms");
    }

    public static void benchmarkCRF() {
        Properties props = new Properties();
        props.setProperty("macro", "true");
        props.setProperty("useIfInteger", "true");
        props.setProperty("featureFactory", "edu.stanford.nlp.benchmarks.BenchmarkFeatureFactory");
        props.setProperty("saveFeatureIndexToDisk", "false");
        CRFClassifier crf = new CRFClassifier(props);
        Random r = new Random(42L);
        ArrayList data = new ArrayList();
        for (int i = 0; i < 100; ++i) {
            ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
            for (int j = 0; j < 20; ++j) {
                CoreLabel l = new CoreLabel();
                l.setWord("j:" + j);
                boolean tag = j % 2 == 0 ^ r.nextDouble() > 0.7;
                l.set(CoreAnnotations.AnswerAnnotation.class, "target:" + tag);
                sentence.add(l);
            }
            data.add(sentence);
        }
        long msStart = System.currentTimeMillis();
        crf.train(data);
        long delay = System.currentTimeMillis() - msStart;
        System.out.println("Training took " + delay + " ms");
    }

    public static void benchmarkSGD() {
        Dataset data = new Dataset();
        for (int i = 0; i < 10000; ++i) {
            Random r = new Random(42L);
            HashSet<String> features = new HashSet<String>();
            boolean cl = r.nextBoolean();
            for (int j = 0; j < 1000; ++j) {
                if (cl && i % 2 == 0) {
                    if (r.nextDouble() > 0.3) {
                        features.add("f:" + j + ":true");
                        continue;
                    }
                    features.add("f:" + j + ":false");
                    continue;
                }
                if (r.nextDouble() > 0.3) {
                    features.add("f:" + j + ":false");
                    continue;
                }
                features.add("f:" + j + ":false");
            }
            data.add(new BasicDatum(features, "target:" + cl));
        }
        LinearClassifierFactory factory = new LinearClassifierFactory();
        factory.setMinimizerCreator(new Factory<Minimizer<DiffFunction>>(){

            @Override
            public Minimizer<DiffFunction> create() {
                return new SGDMinimizer<DiffFunction>(0.1, 100, 0, 1000);
            }
        });
        long msStart = System.currentTimeMillis();
        factory.trainClassifier((GeneralDataset)data);
        long delay = System.currentTimeMillis() - msStart;
        System.out.println("Training took " + delay + " ms");
    }

    public static void benchmarkDatum() {
        long msStart = System.currentTimeMillis();
        Dataset data = new Dataset();
        for (int i = 0; i < 10000; ++i) {
            Random r = new Random(42L);
            HashSet<String> features = new HashSet<String>();
            boolean cl = r.nextBoolean();
            for (int j = 0; j < 1000; ++j) {
                if (cl && i % 2 == 0) {
                    if (r.nextDouble() > 0.3) {
                        features.add("f:" + j + ":true");
                        continue;
                    }
                    features.add("f:" + j + ":false");
                    continue;
                }
                if (r.nextDouble() > 0.3) {
                    features.add("f:" + j + ":false");
                    continue;
                }
                features.add("f:" + j + ":false");
            }
            data.add(new BasicDatum(features, "target:" + cl));
        }
        long delay = System.currentTimeMillis() - msStart;
        System.out.println("Dataset construction took " + delay + " ms");
        msStart = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            Random r = new Random(42L);
            HashSet features = new HashSet();
            boolean cl = r.nextBoolean();
            for (int j = 0; j < 1000; ++j) {
                if (!(cl && i % 2 == 0 ? r.nextDouble() > 0.3 : r.nextDouble() > 0.3)) continue;
            }
        }
        delay = System.currentTimeMillis() - msStart;
        System.out.println("MultiVector took " + delay + " ms");
    }

    public static void testAdjacency() {
        double[][] sqar = new double[10000][1000];
        Random r = new Random();
        int k = 0;
        long msStart = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            int loc = r.nextInt(10000);
            for (int j = 0; j < 1000; ++j) {
                k = (int)((double)k + sqar[loc][j]);
            }
        }
        long delay = System.currentTimeMillis() - msStart;
        System.out.println("Scanning with cache friendly lookups took " + delay + " ms");
        int[] randLocs = new int[10000];
        for (int i = 0; i < 10000; ++i) {
            randLocs[i] = r.nextInt(10000);
        }
        k = 0;
        msStart = System.currentTimeMillis();
        for (int j = 0; j < 1000; ++j) {
            for (int i = 0; i < 10000; ++i) {
                k = (int)((double)k + sqar[randLocs[i]][j]);
            }
        }
        delay = System.currentTimeMillis() - msStart;
        System.out.println("Scanning with cache UNfriendly lookups took " + delay + " ms");
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100; ++i) {
            Benchmarks.benchmarkSGD();
        }
    }
}

