/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.eig.watched;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.eig.watched.WatchedDoubleStepQREigen;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.LinearSolver;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;
import org.ejml.ops.SpecializedOps;

public class WatchedDoubleStepQREigenvector {
    WatchedDoubleStepQREigen implicit;
    DenseMatrix64F Q;
    DenseMatrix64F[] eigenvectors;
    DenseMatrix64F eigenvectorTemp;
    LinearSolver solver;
    Complex64F[] origEigenvalues;
    int N;
    int[] splits;
    int numSplits;
    int x1;
    int x2;
    int indexVal;
    boolean onscript;

    public boolean process(WatchedDoubleStepQREigen watchedDoubleStepQREigen, DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        this.implicit = watchedDoubleStepQREigen;
        if (this.N != denseMatrix64F.numRows) {
            this.N = denseMatrix64F.numRows;
            this.Q = new DenseMatrix64F(this.N, this.N);
            this.splits = new int[this.N];
            this.origEigenvalues = new Complex64F[this.N];
            this.eigenvectors = new DenseMatrix64F[this.N];
            this.eigenvectorTemp = new DenseMatrix64F(this.N, 1);
            this.solver = LinearSolverFactory.linear(0);
        } else {
            this.eigenvectors = new DenseMatrix64F[this.N];
        }
        System.arraycopy(watchedDoubleStepQREigen.eigenvalues, 0, this.origEigenvalues, 0, this.N);
        watchedDoubleStepQREigen.setup(denseMatrix64F);
        watchedDoubleStepQREigen.setQ(this.Q);
        this.numSplits = 0;
        this.onscript = true;
        if (!this.findQandR()) {
            return false;
        }
        return this.extractVectors(denseMatrix64F2);
    }

    public boolean extractVectors(DenseMatrix64F denseMatrix64F) {
        UtilEjml.memset(this.eigenvectorTemp.data, 0.0);
        boolean bl = true;
        for (int i = 0; i < this.N; ++i) {
            Complex64F complex64F = this.implicit.eigenvalues[this.N - i - 1];
            if (bl && !complex64F.isReal()) {
                bl = false;
            }
            if (!complex64F.isReal() || this.eigenvectors[this.N - i - 1] != null) continue;
            this.solveEigenvectorDuplicateEigenvalue(complex64F.real, i, bl);
        }
        if (denseMatrix64F != null) {
            DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.N, 1);
            for (int i = 0; i < this.N; ++i) {
                DenseMatrix64F denseMatrix64F3 = this.eigenvectors[i];
                if (denseMatrix64F3 == null) continue;
                CommonOps.mult(denseMatrix64F, denseMatrix64F3, denseMatrix64F2);
                this.eigenvectors[i] = denseMatrix64F2;
                denseMatrix64F2 = denseMatrix64F3;
            }
        }
        return true;
    }

    private void solveEigenvectorDuplicateEigenvalue(double d, int n, boolean bl) {
        double d2 = Math.abs(d);
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        this.eigenvectorTemp.reshape(this.N, 1, false);
        this.eigenvectorTemp.zero();
        if (n > 0) {
            if (bl) {
                this.solveUsingTriangle(d, n, this.eigenvectorTemp);
            } else {
                this.solveWithLU(d, n, this.eigenvectorTemp);
            }
        }
        this.eigenvectorTemp.reshape(this.N, 1, false);
        for (int i = n; i < this.N; ++i) {
            Complex64F complex64F = this.implicit.eigenvalues[this.N - i - 1];
            if (!complex64F.isReal() || !(Math.abs(complex64F.real - d) / d2 < 100.0 * UtilEjml.EPS)) continue;
            this.eigenvectorTemp.data[i] = 1.0;
            DenseMatrix64F denseMatrix64F = new DenseMatrix64F(this.N, 1);
            CommonOps.multTransA(this.Q, this.eigenvectorTemp, denseMatrix64F);
            this.eigenvectors[this.N - i - 1] = denseMatrix64F;
            NormOps.normalizeF(denseMatrix64F);
            this.eigenvectorTemp.data[i] = 0.0;
        }
    }

    private void solveUsingTriangle(double d, int n, DenseMatrix64F denseMatrix64F) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            this.implicit.A.add(n2, n2, -d);
        }
        SpecializedOps.subvector(this.implicit.A, 0, n, n, false, 0, denseMatrix64F);
        CommonOps.changeSign(denseMatrix64F);
        TriangularSolver.solveU(this.implicit.A.data, denseMatrix64F.data, this.implicit.A.numRows, 0, n);
        for (n2 = 0; n2 < n; ++n2) {
            this.implicit.A.add(n2, n2, d);
        }
    }

    private void solveWithLU(double d, int n, DenseMatrix64F denseMatrix64F) {
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(n, n);
        CommonOps.extract(this.implicit.A, 0, n, 0, n, denseMatrix64F2, 0, 0);
        for (int i = 0; i < n; ++i) {
            denseMatrix64F2.add(i, i, -d);
        }
        denseMatrix64F.reshape(n, 1, false);
        SpecializedOps.subvector(this.implicit.A, 0, n, n, false, 0, denseMatrix64F);
        CommonOps.changeSign(denseMatrix64F);
        if (!this.solver.setA(denseMatrix64F2)) {
            throw new RuntimeException("Solve failed");
        }
        this.solver.solve(denseMatrix64F, denseMatrix64F);
    }

    public boolean findQandR() {
        CommonOps.setIdentity(this.Q);
        this.x1 = 0;
        this.x2 = this.N - 1;
        this.indexVal = 0;
        while (this.indexVal < this.N) {
            if (this.findNextEigenvalue()) continue;
            return false;
        }
        return true;
    }

    private boolean findNextEigenvalue() {
        boolean bl = false;
        while (!bl && this.implicit.steps < this.implicit.maxIterations) {
            this.implicit.incrementSteps();
            if (this.x2 < this.x1) {
                this.moveToNextSplit();
                continue;
            }
            if (this.x2 - this.x1 == 0) {
                this.implicit.addEigenAt(this.x1);
                --this.x2;
                ++this.indexVal;
                bl = true;
                continue;
            }
            if (this.x2 - this.x1 == 1 && !this.implicit.isReal2x2(this.x1, this.x2)) {
                this.implicit.addComputedEigen2x2(this.x1, this.x2);
                this.x2 -= 2;
                this.indexVal += 2;
                bl = true;
                continue;
            }
            if (this.implicit.steps - this.implicit.lastExceptional > this.implicit.exceptionalThreshold) {
                this.implicit.exceptionalShift(this.x1, this.x2);
                this.implicit.lastExceptional = this.implicit.steps;
                continue;
            }
            if (this.implicit.isZero(this.x2, this.x2 - 1)) {
                this.implicit.addEigenAt(this.x2);
                bl = true;
                --this.x2;
                ++this.indexVal;
                continue;
            }
            this.checkSplitPerformImplicit();
        }
        return bl;
    }

    private void checkSplitPerformImplicit() {
        for (int i = this.x2; i > this.x1; --i) {
            if (!this.implicit.isZero(i, i - 1)) continue;
            this.x1 = i;
            this.splits[this.numSplits++] = i - 1;
            return;
        }
        if (this.onscript) {
            if (this.implicit.steps > this.implicit.exceptionalThreshold / 2) {
                this.onscript = false;
            } else {
                Complex64F complex64F = this.origEigenvalues[this.indexVal];
                if (complex64F.isReal()) {
                    this.implicit.performImplicitSingleStep(this.x1, this.x2, complex64F.getReal());
                } else if (this.x2 < this.N - 2) {
                    this.implicit.performImplicitDoubleStep(this.x1, this.x2, complex64F.real, complex64F.imaginary);
                } else {
                    this.onscript = false;
                }
            }
        } else if (this.x2 - this.x1 >= 1 && this.x2 < this.N - 2) {
            this.implicit.implicitDoubleStep(this.x1, this.x2);
        } else {
            this.implicit.performImplicitSingleStep(this.x1, this.x2, this.implicit.A.get(this.x2, this.x2));
        }
    }

    private void moveToNextSplit() {
        if (this.numSplits <= 0) {
            throw new RuntimeException("bad");
        }
        this.x2 = this.splits[--this.numSplits];
        this.x1 = this.numSplits > 0 ? this.splits[this.numSplits - 1] + 1 : 0;
    }

    public DenseMatrix64F getQ() {
        return this.Q;
    }

    public WatchedDoubleStepQREigen getImplicit() {
        return this.implicit;
    }

    public DenseMatrix64F[] getEigenvectors() {
        return this.eigenvectors;
    }

    public Complex64F[] getEigenvalues() {
        return this.implicit.eigenvalues;
    }
}

