/*
 * Decompiled with CFR 0.152.
 */
package org.javaruntype.typedef;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.javaruntype.typedef.TypeDefRegistry;
import org.javaruntype.typedef.TypeDefVariable;
import org.javaruntype.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeDef
implements Serializable {
    private static final long serialVersionUID = 3446428616087989437L;
    private static final String NAME_TYPE_VARIABLES_START = "<";
    private static final String NAME_TYPE_VARIABLES_END = ">";
    private static final String NAME_TYPE_VARIABLES_SEPARATOR = ",";
    private final Class<?> componentClass;
    private final TypeDefVariable[] variables;
    private final String name;
    private final int hashCode;

    private static String createName(Class<?> componentClass, TypeDefVariable[] variables) {
        StringBuilder str = new StringBuilder();
        str.append(componentClass.getName());
        if (variables.length > 0) {
            str.append(NAME_TYPE_VARIABLES_START);
            str.append(Utils.join(variables, NAME_TYPE_VARIABLES_SEPARATOR));
            str.append(NAME_TYPE_VARIABLES_END);
        }
        return str.toString();
    }

    TypeDef(Class<?> componentClass, TypeDefVariable[] variables) {
        Utils.validateNotNull(componentClass, "Component class cannot be null");
        Utils.validateNotNull(variables, "Type parameters cannot be null");
        this.componentClass = componentClass;
        this.variables = (TypeDefVariable[])variables.clone();
        this.name = TypeDef.createName(componentClass, variables);
        this.hashCode = this.name.hashCode();
    }

    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    public TypeDefVariable[] getVariables() {
        return (TypeDefVariable[])this.variables.clone();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeDef other = (TypeDef)obj;
        return this.name.equals(other.name);
    }

    private Object readResolve() throws ObjectStreamException {
        TypeDefRegistry typeDefRegistry = TypeDefRegistry.getInstance();
        return typeDefRegistry.forClass(this.componentClass);
    }
}

