/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Set;

public class AffixDictionary {
    private static final Redwood.RedwoodChannels logger = Redwood.channels(AffixDictionary.class);
    public Set<String> ins;

    public AffixDictionary(String affixFilename) {
        this.ins = AffixDictionary.readDict(affixFilename);
    }

    private Set<String> getInDict() {
        return this.ins;
    }

    private static Set<String> readDict(String filename) {
        Set<String> a = Generics.newHashSet();
        try {
            String aDetectorLine;
            BufferedReader aDetectorReader = IOUtils.readerFromString(filename, "UTF-8");
            while ((aDetectorLine = aDetectorReader.readLine()) != null) {
                a.add(aDetectorLine);
            }
            aDetectorReader.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        logger.info("Loading affix dictionary from " + filename + " [done].");
        return a;
    }

    public String getInDict(String a1) {
        if (this.getInDict().contains(a1)) {
            return "1";
        }
        return "0";
    }
}

