/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.XMLUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import junit.framework.TestCase;

public class XMLUtilsTest
extends TestCase {
    public void testStripTags() {
        String text = "<song><lyrics>Do you think I'm special</lyrics><br><lyrics>Do you think I'm nice</lyrics><br><lyrics whining=\"excessive\">Am I bright enough to shine in your spaces?</lyrics></song>";
        String expectedBreakingResult = "Do you think I'm special\nDo you think I'm nice\nAm I bright enough to shine in your spaces?";
        String result = XMLUtils.stripTags(new BufferedReader(new StringReader(text)), null, true);
        XMLUtilsTest.assertEquals((String)expectedBreakingResult, (String)result);
        String expectedNoBreakingResult = "Do you think I'm specialDo you think I'm niceAm I bright enough to shine in your spaces?";
        result = XMLUtils.stripTags(new BufferedReader(new StringReader(text)), null, false);
        XMLUtilsTest.assertEquals((String)expectedNoBreakingResult, (String)result);
    }

    public void testXMLTag() {
        XMLUtils.XMLTag foo = new XMLUtils.XMLTag("<br />");
        XMLUtilsTest.assertEquals((String)"br", (String)foo.name);
        XMLUtilsTest.assertTrue((boolean)foo.isSingleTag);
        foo = new XMLUtils.XMLTag("<List  name  =   \"Fruit List\"    >");
        XMLUtilsTest.assertEquals((String)"List", (String)foo.name);
        XMLUtilsTest.assertFalse((boolean)foo.isSingleTag);
        XMLUtilsTest.assertFalse((boolean)foo.isEndTag);
        XMLUtilsTest.assertEquals((String)"Fruit List", (String)foo.attributes.get("name"));
        foo = new XMLUtils.XMLTag("</life  >");
        XMLUtilsTest.assertEquals((String)"life", (String)foo.name);
        XMLUtilsTest.assertTrue((boolean)foo.isEndTag);
        XMLUtilsTest.assertFalse((boolean)foo.isSingleTag);
        XMLUtilsTest.assertTrue((boolean)foo.attributes.isEmpty());
        foo = new XMLUtils.XMLTag("<P>");
        XMLUtilsTest.assertEquals((String)"P", (String)foo.name);
    }
}

