/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.TreeShapedStack;
import junit.framework.TestCase;

public class TreeShapedStackTest
extends TestCase {
    public void testEquals() {
        TreeShapedStack<Object> t1 = new TreeShapedStack<String>();
        t1 = t1.push("foo");
        t1 = t1.push("bar");
        t1 = t1.push("bar");
        t1 = t1.push("diet");
        t1 = t1.push("coke");
        TreeShapedStack<Object> t2 = new TreeShapedStack<String>();
        t2 = t2.push("foo");
        t2 = t2.push("bar");
        t2 = t2.push("bar");
        t2 = t2.push("diet");
        t2 = t2.push("coke");
        TreeShapedStack<Object> t3 = t2.pop().push("pepsi");
        TreeShapedStackTest.assertEquals(t1, t2);
        TreeShapedStackTest.assertFalse((boolean)t1.pop().equals(t2));
        TreeShapedStackTest.assertFalse((boolean)t2.pop().equals(t1));
        TreeShapedStackTest.assertFalse((boolean)t2.equals(t3));
    }

    public void testBasicOperations() {
        TreeShapedStack<String> tss = new TreeShapedStack<String>();
        TreeShapedStackTest.assertEquals((int)tss.size, (int)0);
        TreeShapedStack<String> tss1 = tss.push("1");
        TreeShapedStackTest.assertEquals((int)tss1.size, (int)1);
        TreeShapedStackTest.assertEquals((String)tss1.peek(), (String)"1");
        TreeShapedStack<String> tss2 = tss1.push("2");
        TreeShapedStackTest.assertEquals((int)tss2.size, (int)2);
        TreeShapedStackTest.assertEquals((String)tss2.peek(), (String)"2");
        TreeShapedStackTest.assertEquals((String)((String)tss2.previous.peek()), (String)"1");
        TreeShapedStack<String> tss3 = tss2.push("3");
        TreeShapedStackTest.assertEquals((int)tss3.size, (int)3);
        TreeShapedStackTest.assertEquals((String)tss3.peek(), (String)"3");
        TreeShapedStackTest.assertEquals((String)((String)tss3.previous.peek()), (String)"2");
        tss3 = tss3.pop();
        TreeShapedStackTest.assertEquals((String)tss3.peek(), (String)"2");
        TreeShapedStackTest.assertEquals((String)((String)tss3.previous.peek()), (String)"1");
        TreeShapedStackTest.assertEquals((String)tss3.peek(), (String)"2");
        TreeShapedStack<String> tss4 = tss3.push("4");
        TreeShapedStackTest.assertEquals((String)tss4.peek(), (String)"4");
        TreeShapedStackTest.assertEquals((String)tss4.peek(), (String)"4");
        TreeShapedStackTest.assertEquals((String)((String)tss4.previous.peek()), (String)"2");
        tss4 = tss4.pop();
        TreeShapedStackTest.assertEquals((String)tss4.peek(), (String)"2");
        tss4 = tss4.pop();
        TreeShapedStackTest.assertEquals((String)tss4.peek(), (String)"1");
        tss4 = tss4.pop();
        TreeShapedStackTest.assertEquals((int)tss4.size, (int)0);
    }
}

