/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Timing;
import java.text.DecimalFormat;
import java.util.Locale;
import junit.framework.TestCase;

public class TimingTest
extends TestCase {
    protected void setUp() {
        Locale.setDefault(Locale.US);
    }

    public void testTiming() {
        Timing t = new Timing();
        TimingTest.sleepTen();
        long val2 = t.reportNano();
        TimingTest.assertTrue((String)String.format("Wrong nanosleep %d", val2), (val2 < 30000000L ? 1 : 0) != 0);
        TimingTest.assertTrue((String)String.format("Wrong nanosleep %d", val2), (val2 > 3000000L ? 1 : 0) != 0);
        TimingTest.sleepTen();
        long val = t.report();
        TimingTest.assertEquals((String)"Wrong sleep", (float)20.0f, (float)val, (float)20.0f);
        for (int i = 0; i < 8; ++i) {
            TimingTest.sleepTen();
        }
        long val3 = t.report();
        TimingTest.assertEquals((String)"Wrong formatted time", (String)new DecimalFormat("0.0").format(0.1), (String)Timing.toSecondsString(val3));
    }

    private static void sleepTen() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

