/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.EditDistance;
import junit.framework.TestCase;

public class EditDistanceTest
extends TestCase {
    protected EditDistance editDistance;
    public static final String smallTestString = "million";
    public static final String bigTestString = "</div END: M76 Global Navigation - Header BEGIN: Region for all content Article Copy module BEGIN: Module - Main Article Check the Article Type and display accordingly Print Author image associated with the Author Print the body of the article\n\ndiv#related-article-links p a, div#related-article-links p a:visited { color:#06c; }\nPagination Display article with page breaks\n\"I am sure on some level she might have felt empowered and good about it, but on another she would have felt empty and exploited,\" says Pinsky, who has researched the relationship between celebrities and sexuality in his book The Mirror Effect: How Celebrity Narcissism Is Seducing America. \"Generally speaking, when a woman's worth is built on her sexuality, she ends up having flimsy self-esteem.\"\n\nThe first bars of Britney's gilded cage were in place.\n\nFor the first few years, Britney's success was the kind millions of young girls dream of - three albums debuting at No 1, a $3m house in the Hollywood Hills, a loft in New York and, of course, a dreamy boyfriend, Justin Timberlake, her -fellow Mouseketeer in The All New Mickey Mouse Club when they were in their early teens. Yet Lunt says that as she became more successful, Britney became harder and harder to deal with.\n\n\"When artists become successful when they are very young,\" he says, \"they realise they missed out on their whole childhood by working so hard. And when they hit 20 or 21, they think, 'I missed everything between 15 and 20, so I have to catch up.' Suddenly, learning about life becomes more important than the music. In Britney's case, when she wanted to learn about life, there were always 300 cameras watching. To think it doesn't take a toll on someone's -psyche is very naive.\"\n#include file=\"m63-article-related-attachements.html\" Call Wide Article Attachment Module TEMPLATE:call file=\"wideArticleAttachment.jsp\" /\nPeople who know Britney well believe she has never fully recovered from the end of her four-year relationship with Timberlake, when she had just turned 21. Bad enough to have paparazzi cameras documenting your distress; then Timberlake made embarrassing, even humiliating, revelations, discussing on a radio station how he and Britney had had oral sex, and acknowledging in a television interview that they had \"done it\", although Britney was still claiming she was a virgin. Her pristine image was given a further pounding by a rancid interview the Limp Bizkit front man, Fred Durst, gave on Howard Stern's radio show, in which he talked about having sex with Britney and even discussed her pubic hair. Around that time, the tabloids began speculating that she might be dabbling in cocaine and other drugs.\n\nThe first real indication that something was seriously wrong came with the shock news, in early January 2004, that Britney had married Jason Alexander, a childhood friend, at the Little White Wedding Chapel in Las Vegas. As quickly as they got married, they sought and got an annulment. Britney Jean Spears's first marriage lasted only 55 hours.\n\nThree months later, Britney met Kevin Fed-erline, a backup dancer for Timberlake and others, in a Hollywood club. Just three months after that, the pair announced their engagement. Unfortunately, Federline was already in a relationship with an actress. They had one child and she was eight months pregnant with their second. The feeling that Britney was using her pull as a rich, sexy pop star to deprive two children of their father marked a turning point in the way the tabloids treated her.\n\nWhen a five-hour documentary cut together from the newlyweds' home videos, appropriately called Britney and Kevin: Chaotic, was broadcast on American tele-vision in May 2005, the reception was disastrous. The New York Times said the show revealed that Britney \"has the mind of a child trapped in the body of a blow-up doll\". Her maturity was again challenged in February 2006, when she was photographed driving with her young son, Sean Preston, on her lap, not in a car seat. In April she was questioned by the LA Department of Children and Family Services after the child was badly bruised, apparently because he fell out of a high chair; and in May, Britney was snapped nearly dropping him in the street.\n\nBy the time Britney announced she was pregnant again, there were already tabloid rumours that the marriage was on the rocks. Britney was said to be angry that Federline was trying to parlay his new-found celebrity into a career as a rap singer. Jayden James was born in September, and barely two months later Britney filed for divorce, citing irreconcilable differences. Federline was dubbed Fed-Ex, and Britney hit the party scene, seemingly most nights of the week, sometimes in the company of one of her new friends, Paris Hilton, sometimes, as the tabloids enthusiastically and frequently pointed out, minus her knickers.\n\nHer mother believed she was suffering serious postpartum depression, but it also became obvious she was drinking heavily and, according to people in close contact with her, using drugs. Then began the gavotte of checking into rehab centres for 24 hours, then checking out, with time out for shaving her head and attacking a paparazzo's car with an umbrella. She returned to rehab for a month, but less than a month after she was released, she fired Rudolph.\n\nWith her management and family banished, Britney's closest companions became the paparazzi. Tony Barretto, one of her bodyguards during that time, later testified to a court deciding on custody of her children just how disturbing things were in the world of Britney Spears. He later said that not long after she had left rehab, she nearly overdosed in a hotel room with the singer Howie Day, whom she had met in the clinic.\n\n\"She was in a terrible state, just sweating and shaking,\" said Barretto, who was worried she was going to die. \"Her pupils were huge - I've never seen her so bad. There were half-eaten plates of food everywhere. On the surface of the dresser, I could see mounds of white powder and a straw on top. I suspected it was cocaine or powdered methamphetamines. By the side I spotted a glass pipe, which I knew from my drugs training was often used with crystal meth.\" Barretto said he gave evidence to the court because he was extremely concerned about the wellbeing of Britney's young children. \"She's not a good mother,\" he said. \"She has mental problems. Often she would scream and cry uncontrollably.\"\n\nIn May 2007, Britney tried to explain what was happening in her life in a meandering post on her website. \"I truly hit rock bottom,\" she admitted. \"Till this day I don't think it was alcohol or depression. I was like a bad kid running around with ADD. I realised how much energy and love I had put into my past relationship when it was gone because I genuinely did not know what to do with myself, and it made me so sad. I confess, I was so lost.\"\n\n\"She jettisoned everybody out of her life who was offering her good advice,\" Lunt says. \"It was her way of saying, 'I want to make my own decisions, even if they're bad ones.' I personally believe she has low self-esteem. And when you are a famous person, to have low self-esteem makes you extremely vulnerable to the leeches of the world.\"\n\nLunt is specifically referring to Osama \"Sam\" Lutfi, who insinuated himself into Britney's life in October 2007 and started calling himself her manager. Lynne Spears later issued a restraining order against Lutfi, saying he \"essentially moved into Britney's home and has purported to take control of her life, home and finances\". Lutfi said he began a business relationship with the singer \"out of concern for Britney and her wellbeing\". But he had also cultivated a close and presumably lucrative relationship with the celebrity photo agency X17. Brandy -Navarre, vice-president at the agency, said Lutfi communicated with them by e-mail and text messages. X17 always seemed to have photographers strategically placed wherever Britney - and Lutfi - were. The photos were then sold to tabloids around the world for hundreds of thousands of dollars.\n\n\"When all of this stuff crashed around her,\" Navarre says, \"and she didn't have a strong support system, she found it in the paparazzi. It sounds so strange, but we were the only people there for her all the time.\" The situation became even more bizarre when Britney one night invited a paparazzo into her car and began a sexual relationship with him. The paparazzo, Adnan Ghalib, a Brit of Afghan background, started brokering his own photos and videos of the singer.\n#include file=\"m63-article-related-attachements.html\" Call Wide Article Attachment Module TEMPLATE:call file=\"wideArticleAttachment.jsp\" /\nWho was Lutfi? He claimed to be a film producer, among other things, of a B-movie called Bug Buster. The film's real producer says he was just his assistant. \"He was a hustler type, a fast-talking kid.\" It later emerged that Lutfi had a troubling background and that at least two people had filed restraining orders against him. One complained that his harassment of her had become \"an overwhelming nightmare\".\n\nIn a lawsuit he later filed, Lutfi claimed that Britney's parents saw his relationship with their daughter as a \"threat to their lifestyle\" and started to \"drive him out of Britney's life. Jamie and Lynne set out to destroy anyone and anything that came between them and Britney, first by pressuring and cajoling Britney into annulling her marriage to longtime friend Jason Alexander, and later by interfering with Britney's marriage to Kevin Federline\". Lutfi also claimed that Britney had appointed him as her manager in October 2007, and that she had agreed he would be paid 15% of her income - which he put at about $800,000 a month - for four years.\n\nIn a restraining order against Lutfi filed in early 2008, Lynne gave a very different and disturbing picture of his relationship with her daughter. During a fight between them, she claimed: \"Sam had told Britney she was an unfit mother, a piece of trash and a whore.\" She also said that Lutfi told her he \"grinds up Britney's pills, which included Risperdol [Risperdal is a drug used to control manic episodes] and Seroquel [a mood stabliliser also used for bipolar mental illness]. He told us he puts them in her food and that was the reason she has been quiet for the last three days\".\n\nLynne said Lutfi \"told me that if he weren't in the house to give Britney her medicine, she would kill herself. Then he said to me, 'If you try to get rid of me, she'll be dead and I'll piss on her grave'\". According to Lynne, Ghalib called her and told her that Lutfi would hide Britney's phones and tell her he'd lost them. \"He also hides her dog, London. She looks for him all over the house, crying, and then Sam brings the dog out from the hiding place and acts like her saviour.\"\n\nLufti disputes all these assertions and has issued a libel suit against Lynne for repeating some of them in Through the Storm.\n\n\"As far as I'm concerned, people like that are just the scum of the earth,\" Lunt says. \"To see them taking advantage and trying to control someone you feel protective towards is heart-breaking and frustrating, because there is nothing you can really do. And if I felt like that, imagine how Britney's parents felt, having their daughter brainwashed and shut out by these people. That must be the worst feeling in the world.\"\n\nIn September 2007, Britney lost custody of her children because of her \"habitual, frequent and continuous use of controlled substances and alcohol\", the judge ruled. On January 3, 2008, Britney, who had not slept for days, refused to give her children back to Federline. According to newspaper reports, she locked herself in a bathroom, \"sobbing uncontrollably, repeating that she would kill herself\". Finally, in a terrible scene, Britney was taken from the house on a gurney and driven to Cedars-Sinai Medical Center in an ambulance, under a police car and helicopter escort. There, she was placed under an involuntary 72-hour psychiatric hold.\n\n\"She had a life-threatening psychiatric illness,\" Pinsky explains. \"You don't get locked in a 72-hour hold unless you have a profound psychiatric disorder. They are the most ill patients in a psychiatric hospital.\"\n\nAlthough she was released, on January 31, on the orders of her psychiatrist, she was removed from her home again, this time by 20 police officers, and placed again in involuntary psychiatric lockdown. That committal, which the Spears family believe was initiated by Lutfi, gave them the ammunition they needed to file a restraining order against him, and on February 1 Jamie applied for and was granted temporary conservatorship over Britney. It has since been extended and remains in force 16 months later.\n\n\"It's really because of them stepping in, getting a conservatorship, doing all these aggressive manoeuvres that Britney is alive today,\" Pinsky says. Yet, though alive, how well is she really?\n\nGiven how physically gruelling her Circus tour is, it's not surprising that recent photos of Britney on the beach show her in the best shape she's been in for at least five years, slim and toned. Her stamina is remarkable, but some critics feel there is something vacant and disengaged about her. People magazine said there was a \"lack of joy in her performance\".\n\nNavarre, of X17, agrees: \"When I look at the pictures and see her perform, which is when she's supposed to be at her happiest and her best, she just doesn't look happy. She doesn't have that same smile, that same spark, that she used to. She seems closed and cold. She's almost been turned into a robot. I don't know what kind of medication she's on, but she isn't herself.\"\n#include file=\"m63-article-related-attachements.html\" Call Wide Article Attachment Module TEMPLATE:call file=\"wideArticleAttachment.jsp\" /\nAnd, if she is in good enough health to be engaged in one of the most gruelling tours in pop history, why is she still subject to the extremely restrictive conditions of the conservatorship? William McGovern, a law professor at UCLA who was asked to look at the issues of Britney's conservatorship, says he finds \"the restrictions on her personal freedom very odd. Not being able to receive telephone calls? You're supposed to be able to hire your own lawyer. How can you hire your own lawyer when your telephone is cut off? The whole thing smells fishy to me\".\n\nLast year, a lawyer who wanted to help free Britney from the conservatorship, but has so far been banned from doing so by the courts, released a message the singer had left on his voice mail. \"Hi, my name's Britney Spears,\" she said. \"I called you earlier. I'm calling again because I just wanted to make sure that during the process of eliminating the conservatorship, my father has threatened me several times, you know, he'll take my children away. I just want to be guaranteed that everything will be fine with the process of you guys taking care of everything, that things will stay the same as far as my custodial time. That's it, bye.\"\n\nAlthough few people would defend Lutfi, many might agree with what his lawyer, Bryan Freedman, said when filing a suit against the Spears family. \"Why would a loving father, who deems his daughter to be incompetent, thrust her into a massive world tour only to subject her to the very limelight that threatened to shatter her life, for something other than his own personal gain?\"\n\n\"You have to wonder why Jamie would be so interested in getting her back to work so quickly,\" Navarre says. \"Some people would argue that he needed to keep the cash flowing, so he put the show pony out there and stuck her on the road again.\"\n\nLunt, however, believes that Britney may have needed to work and tour to heal. \"I have a theory about people who get up on stage,\" he says. \"Usually there is a hole somewhere in them that can only be filled by 20,000 strangers chanting their name. She's not getting up there just so her father can have money. She's getting up there because she wants a career. Her career defines who she is. And she would rather be known for being a performer than for being somebody who shaves her head and sticks an umbrella through a car window.\"\n\nDespite his praise for Jamie's intervention, Pinsky has serious doubts about how effectively Britney is being treated for her psychological problems, especially while she is under such tremendous pressure on tour. \"My concern is whether there is an addiction lurking, and when the reins are let up slightly, are we going to see that re-emerge in some fashion? If that happens, then her prognosis shifts again, to very poor.\"\n\nPinsky is troubled by something else: that Britney asked for DVDs of her favourite Marilyn Monroe movies to be in her hotel room at the Dorchester while she is in London. \"Here's the reality: Marilyn Monroe was a profoundly disturbed, sexually abused opiate addict who died of her addiction. For Britney to idealise that, or even in any way wish to emulate or identify with it, is very troubling. It concerns me mostly because the last time we saw that clear phenomenon was with Anna Nicole Smith, so if that's an indication of what this means...\"\n</POST>";

    protected void setUp() {
        this.editDistance = new EditDistance();
    }

    public void testBig() {
        EditDistanceTest.assertEquals((Object)17180.0, (Object)this.editDistance.score(bigTestString, smallTestString));
    }

    public void testInsert() {
        EditDistanceTest.assertEquals((Object)4.0, (Object)this.editDistance.score("Hi!", "Hi you!"));
        EditDistanceTest.assertEquals((Object)5.0, (Object)this.editDistance.score("Hi!", "Hi you!?"));
        EditDistanceTest.assertEquals((Object)1.0, (Object)this.editDistance.score("sdf", "asdf"));
        EditDistanceTest.assertEquals((Object)1.0, (Object)this.editDistance.score("asd", "asdf"));
    }

    public void testDelete() {
        EditDistanceTest.assertEquals((Object)4.0, (Object)this.editDistance.score("Hi you!", "Hi!"));
        EditDistanceTest.assertEquals((Object)5.0, (Object)this.editDistance.score("Hi you!?", "Hi!"));
        EditDistanceTest.assertEquals((Object)1.0, (Object)this.editDistance.score("asdf", "asd"));
        EditDistanceTest.assertEquals((Object)1.0, (Object)this.editDistance.score("asdf", "sdf"));
    }

    public void testModify() {
        EditDistanceTest.assertEquals((Object)3.0, (Object)this.editDistance.score("Hi you!", "Hi Sir!"));
        EditDistanceTest.assertEquals((Object)5.0, (Object)this.editDistance.score("Hi you!", "Hi Sir!!!"));
    }

    public void testTranspose() {
        EditDistanceTest.assertEquals((Object)1.0, (Object)this.editDistance.score("hello", "hlelo"));
        EditDistanceTest.assertEquals((Object)1.0, (Object)this.editDistance.score("asdf", "adsf"));
        EditDistanceTest.assertEquals((Object)1.0, (Object)this.editDistance.score("asdf", "sadf"));
        EditDistanceTest.assertEquals((Object)1.0, (Object)this.editDistance.score("asdf", "asfd"));
    }

    public void testEmpty() {
        EditDistanceTest.assertEquals((Object)0.0, (Object)this.editDistance.score("", ""));
        EditDistanceTest.assertEquals((Object)3.0, (Object)this.editDistance.score("", "bar"));
        EditDistanceTest.assertEquals((Object)3.0, (Object)this.editDistance.score("foo", ""));
    }
}

