/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.stats.Counter;
import org.junit.Assert;

public class BenchmarkingHelper {
    private BenchmarkingHelper() {
    }

    public static void setLowHighExpected(Counter<String> lowRes, Counter<String> highRes, Counter<String> expRes, String key, double lowVal, double highVal, double expVal) {
        lowRes.setCount(key, lowVal);
        highRes.setCount(key, highVal);
        expRes.setCount(key, expVal);
    }

    public static void benchmarkResults(Counter<String> results, Counter<String> lowResults, Counter<String> highResults, Counter<String> expectedResults) {
        if (results.keySet().isEmpty()) {
            Assert.fail((String)"There are no results to benchmark!");
        }
        for (String key : results.keySet()) {
            if (!highResults.containsKey(key) || !lowResults.containsKey(key)) {
                Assert.fail((String)("Missing performance bounds for " + key));
            }
            double val = results.getCount(key);
            double high = highResults.getCount(key);
            double low = lowResults.getCount(key);
            Assert.assertTrue((String)("Value for " + key + " = " + val + " is lower than expected minimum " + low), (val >= low ? 1 : 0) != 0);
            Assert.assertTrue((String)("Value for " + key + " = " + val + " is higher than expected maximum " + high + " [not a bug, but a breakthrough!]"), (val <= high ? 1 : 0) != 0);
            if (expectedResults == null) {
                System.err.printf("Value for %s = %.4f is within the expected range [%.4f, %.4f]%n", key, val, low, high);
                continue;
            }
            double expected = expectedResults.getCount(key);
            if (val < expected - 1.0E-4) {
                System.err.printf("Value for %s = %.4f is slightly lower than expected %.4f%n", key, val, expected);
                continue;
            }
            if (val > expected + 1.0E-4) {
                System.err.printf("Value for %s = %.4f is slightly higher than expected %.4f%n", key, val, expected);
                continue;
            }
            System.err.printf("Value for %s  = %.4f is as expected%n", key, val);
        }
    }
}

