/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Beam;
import edu.stanford.nlp.util.Scored;
import edu.stanford.nlp.util.ScoredComparator;
import edu.stanford.nlp.util.ScoredObject;
import junit.framework.TestCase;

public class BeamTest
extends TestCase {
    protected Beam<ScoredObject<String>> beam;
    protected ScoredObject<String> object1;
    protected ScoredObject<String> object0;
    protected ScoredObject<String> object2;
    protected ScoredObject<String> object3;

    protected void setUp() {
        this.beam = new Beam<Scored>(2, ScoredComparator.ASCENDING_COMPARATOR);
        this.object1 = new ScoredObject<String>("1", 1.0);
        this.object2 = new ScoredObject<String>("2", 2.0);
        this.object3 = new ScoredObject<String>("3", 3.0);
        this.object0 = new ScoredObject<String>("0", 0.0);
        this.beam.add(this.object1);
        this.beam.add(this.object2);
        this.beam.add(this.object3);
        this.beam.add(this.object0);
    }

    public void testSize() {
        BeamTest.assertEquals((int)2, (int)this.beam.size());
    }

    public void testContent() {
        BeamTest.assertTrue((boolean)this.beam.contains(this.object2));
        BeamTest.assertTrue((boolean)this.beam.contains(this.object3));
        BeamTest.assertFalse((boolean)this.beam.contains(this.object1));
        BeamTest.assertFalse((boolean)this.beam.contains(this.object0));
    }
}

