/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.ud;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.ud.CoNLLUDocumentReader;
import edu.stanford.nlp.trees.ud.CoNLLUDocumentWriter;
import java.io.StringReader;
import java.util.Iterator;
import junit.framework.TestCase;

public class CoNLLUDocumentReaderWriterTest
extends TestCase {
    private static String MULTIWORD_TEST_INPUT = "1     I         I      PRON    PRP   Case=Nom|Number=Sing|Person=1     2   nsubj   _   _\n2-3   haven't   _      _       _     _                                 _   _   _   _\n2     have      have   VERB    VBP    Number=Sing|Person=1|Tense=Pres   0   root   _   _\n3     not       not    PART    RB    Negative=Neg                      2   neg   _   _\n4     a         a      DET     DT    Definite=Ind|PronType=Art         5   det   _   _\n5     clue      clue   NOUN    NN    Number=Sing                       2   dobj   _   _\n6     .         .      PUNCT   .     _                                 2   punct   _   _\n\n";
    private static String COMMENT_TEST_INPUT = "#comment line 1\n#comment line 2\n1     I         I      PRON    PRP   Case=Nom|Number=Sing|Person=1     2   nsubj   _   _\n2     have      have   VERB    VBP    Number=Sing|Person=1|Tense=Pres   0   root   _   _\n3     not       not    PART    RB    Negative=Neg                      2   neg   _   _\n4     a         a      DET     DT    Definite=Ind|PronType=Art         5   det   _   _\n5     clue      clue   NOUN    NN    Number=Sing                       2   dobj   _   _\n6     .         .      PUNCT   .     _                                 2   punct   _   _\n\n";
    private static String EXTRA_DEPS_TEST_INPUT = "1     They       They       PRON    PRP    _    2   nsubj   2:nsubj|4:nsubj         _\n2     buy        buy        VERB    VBP    _    0   root    0:root               _\n3     and        and        CONJ    CC     _    2   cc      2:cc               _\n4     sell       sell       VERB    VBP    _    5   conj    5:conj               _\n5     books      book       NOUN    NNS    _    2   dobj    2:dobj|4:dobj          _\n6     ,          ,          PUNCT   ,      _    5   punct   5:punct               _\n7     newspapers newspaper  NOUN    NNS    _    5   conj    2:dobj|4:dobj|5:conj   _\n8     and        and        CONJ    CC     _    5   cc      5:cc               _\n9     magazines  magazine   NOUN    NNS    _    5   conj    2:dobj|4:dobj|5:conj   _\n10    .          .          PUNCT   .      _    2   punct   2:punct               _\n\n";
    private static String EXTRA_DEPS_TEST_EMPTY_NODEINPUT = "1     They       They       PRON    PRP    _    2   nsubj   2:nsubj|2.1:nsubj|2.2:nsubj         _\n2     buy        buy        VERB    VBP    _    0   root    0:root               _\n2.1     buy        buy        VERB    VBP    _    _   _    2:conj:and               _\n2.2     buy        buy        VERB    VBP    _    _   _    2:conj:and               _\n3     books      book       NOUN    NNS    _    2   dobj    2:dobj          _\n4     ,          ,          PUNCT   ,      _    3   punct   3:punct               _\n5     newspapers newspaper  NOUN    NNS    _    3   conj    2.1:dobj|3:conj   _\n6     and        and        CONJ    CC     _    3   cc      3:cc               _\n7     magazines  magazine   NOUN    NNS    _    3   conj    2.2:dobj|3:conj   _\n8    .          .          PUNCT   .      _    2   punct   2:punct               _\n\n";

    public void testMultiWords() {
        CoNLLUDocumentReader reader = new CoNLLUDocumentReader();
        StringReader stringReader = new StringReader(MULTIWORD_TEST_INPUT);
        Iterator<SemanticGraph> it = reader.getIterator(stringReader);
        SemanticGraph sg = it.next();
        CoNLLUDocumentReaderWriterTest.assertNotNull((Object)sg);
        CoNLLUDocumentReaderWriterTest.assertFalse((String)"The input only contains one dependency tree.", (boolean)it.hasNext());
        CoNLLUDocumentReaderWriterTest.assertEquals((String)"[have/VBP nsubj>I/PRP neg>not/RB dobj>[clue/NN det>a/DT] punct>./.]", (String)sg.toCompactString(true));
        for (IndexedWord iw : sg.vertexListSorted()) {
            if (iw.index() != 2 && iw.index() != 3) {
                CoNLLUDocumentReaderWriterTest.assertEquals((String)"", (String)iw.originalText());
                continue;
            }
            CoNLLUDocumentReaderWriterTest.assertEquals((String)"haven't", (String)iw.originalText());
        }
        CoNLLUDocumentReaderWriterTest.assertEquals((Object)3, sg.getNodeByIndex(2).get(CoreAnnotations.LineNumberAnnotation.class));
    }

    public void testComment() {
        CoNLLUDocumentReader reader = new CoNLLUDocumentReader();
        StringReader stringReader = new StringReader(COMMENT_TEST_INPUT);
        Iterator<SemanticGraph> it = reader.getIterator(stringReader);
        SemanticGraph sg = it.next();
        CoNLLUDocumentReaderWriterTest.assertNotNull((Object)sg);
        CoNLLUDocumentReaderWriterTest.assertFalse((String)"The input only contains one dependency tree.", (boolean)it.hasNext());
        CoNLLUDocumentReaderWriterTest.assertEquals((String)"[have/VBP nsubj>I/PRP neg>not/RB dobj>[clue/NN det>a/DT] punct>./.]", (String)sg.toCompactString(true));
        CoNLLUDocumentReaderWriterTest.assertEquals((Object)3, sg.getNodeByIndex(1).get(CoreAnnotations.LineNumberAnnotation.class));
        CoNLLUDocumentReaderWriterTest.assertEquals((int)2, (int)sg.getComments().size());
        CoNLLUDocumentReaderWriterTest.assertEquals((String)"#comment line 1", (String)sg.getComments().get(0));
    }

    public void testExtraDependencies() {
        CoNLLUDocumentReader reader = new CoNLLUDocumentReader();
        StringReader stringReader = new StringReader(EXTRA_DEPS_TEST_INPUT);
        Iterator<SemanticGraph> it = reader.getIterator(stringReader);
        SemanticGraph sg = it.next();
        CoNLLUDocumentReaderWriterTest.assertNotNull((Object)sg);
        CoNLLUDocumentReaderWriterTest.assertFalse((String)"The input only contains one dependency tree.", (boolean)it.hasNext());
        CoNLLUDocumentReaderWriterTest.assertTrue((boolean)sg.containsEdge(sg.getNodeByIndex(4), sg.getNodeByIndex(1)));
        CoNLLUDocumentReaderWriterTest.assertTrue((boolean)sg.containsEdge(sg.getNodeByIndex(2), sg.getNodeByIndex(7)));
        CoNLLUDocumentReaderWriterTest.assertTrue((boolean)sg.containsEdge(sg.getNodeByIndex(4), sg.getNodeByIndex(7)));
    }

    private void testSingleReadAndWrite(String input) {
        String clean = input.replaceAll("[\\t ]+", "\t");
        CoNLLUDocumentReader reader = new CoNLLUDocumentReader();
        CoNLLUDocumentWriter writer = new CoNLLUDocumentWriter();
        StringReader stringReader = new StringReader(clean);
        Iterator<SemanticGraph> it = reader.getIterator(stringReader);
        SemanticGraph sg = it.next();
        String output = writer.printSemanticGraph(sg);
        CoNLLUDocumentReaderWriterTest.assertEquals((String)clean, (String)output);
    }

    public void testReadingAndWriting() {
        this.testSingleReadAndWrite(COMMENT_TEST_INPUT);
        this.testSingleReadAndWrite(EXTRA_DEPS_TEST_INPUT);
        this.testSingleReadAndWrite(MULTIWORD_TEST_INPUT);
        this.testSingleReadAndWrite(EXTRA_DEPS_TEST_EMPTY_NODEINPUT);
    }
}

