/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import java.io.Serializable;
import java.util.function.Predicate;

public class FragmentTreeFilter
implements Predicate<Tree>,
Serializable {
    static final TregexPattern threeNodePattern = TregexPattern.compile("FRAG=root <, (PU <: /\uff08/) <2 (VV <: /\u5b8c/) <- (PU=a <: /\uff09/) <3 =a : =root !> (__ > __)");
    static final TregexPattern oneNodePattern = TregexPattern.compile("FRAG=root <: (VV <: /\u5b8c/) : =root !> (__ > __)");
    static final TregexPattern automaticInitialPattern = TregexPattern.compile("automatic=root <: (initial !< __) : =root !> __");
    static final TregexPattern manuallySegmentedPattern = TregexPattern.compile("manually=root <: (segmented !< __) : =root !> __");
    static final TregexPattern onthewayPattern = TregexPattern.compile("FRAG=root <: (NR <: (ontheway !< __)) : =root !> (__ > __)");
    static final TregexPattern singlePuncFragPattern = TregexPattern.compile("__ !> __ <: (PU=punc <: __)");
    static final TregexPattern singlePuncPattern = TregexPattern.compile("PU=punc !> __ <: __");
    static final TregexPattern metaPattern = TregexPattern.compile("META !> __ <: NN");
    static final TregexPattern bracketPattern = TregexPattern.compile("/[<>]/");
    static final TregexPattern[] patterns = new TregexPattern[]{threeNodePattern, oneNodePattern, automaticInitialPattern, manuallySegmentedPattern, onthewayPattern, singlePuncFragPattern, singlePuncPattern, metaPattern, bracketPattern};
    private static final long serialVersionUID = 1L;

    @Override
    public boolean test(Tree tree) {
        for (TregexPattern pattern : patterns) {
            if (!pattern.matcher(tree).find()) continue;
            return false;
        }
        return true;
    }
}

