/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.negra.NegraPennLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraPennTreeReaderFactory;
import junit.framework.TestCase;

public class NegraPennLanguagePackTest
extends TestCase {
    public void testBasicCategory() {
        NegraPennLanguagePack lp1 = new NegraPennLanguagePack(false);
        NegraPennLanguagePack lp2 = new NegraPennLanguagePack(true);
        NegraPennTreeReaderFactory trf01 = new NegraPennTreeReaderFactory(0, false, false, lp1);
        NegraPennTreeReaderFactory trf02 = new NegraPennTreeReaderFactory(0, false, false, lp2);
        NegraPennTreeReaderFactory trf11 = new NegraPennTreeReaderFactory(1, false, false, lp1);
        NegraPennTreeReaderFactory trf12 = new NegraPennTreeReaderFactory(1, false, false, lp2);
        NegraPennTreeReaderFactory trf21 = new NegraPennTreeReaderFactory(2, false, false, lp1);
        NegraPennTreeReaderFactory trf22 = new NegraPennTreeReaderFactory(2, false, false, lp2);
        String tree = "( (S (NE-SB Kronos) (VAFIN-HD haben) (VP-OC (PP-MO (APPR-AC mit) (PPOSAT-NK ihrer) (NN-NK Musik)) (NN-OA Br\u00fccken) (VVPP-HD geschlagen))) ($. .))";
        String ans1 = "(ROOT (S (NE-SB Kronos) (VAFIN-HD haben) (VP-OC (PP-MO (APPR-AC mit) (PPOSAT-NK ihrer) (NN-NK Musik)) (NN-OA Br\u00fccken) (VVPP-HD geschlagen)) ($. .)))";
        String ans21 = "(ROOT (S (NE Kronos) (VAFIN haben) (VP (PP (APPR mit) (PPOSAT ihrer) (NN Musik)) (NN Br\u00fccken) (VVPP geschlagen)) ($. .)))";
        String ans22 = "(ROOT (S (NE-SB Kronos) (VAFIN haben) (VP (PP (APPR mit) (PPOSAT ihrer) (NN Musik)) (NN-OA Br\u00fccken) (VVPP geschlagen)) ($. .)))";
        Tree t01 = Tree.valueOf(tree, trf01);
        Tree t02 = Tree.valueOf(tree, trf02);
        Tree t11 = Tree.valueOf(tree, trf11);
        Tree t12 = Tree.valueOf(tree, trf12);
        Tree t21 = Tree.valueOf(tree, trf21);
        Tree t22 = Tree.valueOf(tree, trf22);
        NegraPennLanguagePackTest.assertEquals((String)"T01", (String)ans1, (String)t01.toString());
        NegraPennLanguagePackTest.assertEquals((String)"T02", (String)ans1, (String)t02.toString());
        NegraPennLanguagePackTest.assertEquals((String)"T11", (String)ans1, (String)t11.toString());
        NegraPennLanguagePackTest.assertEquals((String)"T12", (String)ans1, (String)t12.toString());
        NegraPennLanguagePackTest.assertEquals((String)"T21", (String)ans21, (String)t21.toString());
        NegraPennLanguagePackTest.assertEquals((String)"T22", (String)ans22, (String)t22.toString());
        String ans = lp1.basicCategory("---CJ");
        NegraPennLanguagePackTest.assertEquals((String)"BC1", (String)"-", (String)ans);
    }
}

