/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.trees.CollinsRelation;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.DependencyFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Set;

public class CollinsDependency
implements Dependency<CoreLabel, CoreLabel, String> {
    private static Redwood.RedwoodChannels log = Redwood.channels(CollinsDependency.class);
    private static final long serialVersionUID = -4236496863919294754L;
    private static final String normPOSLabel = "TAG";
    private final CoreLabel modifier;
    private final CoreLabel head;
    private final CollinsRelation relation;

    public CollinsDependency(CoreLabel modifier, CoreLabel head, CollinsRelation rel) {
        if (modifier.index() == 0) {
            throw new RuntimeException("No index annotation for " + modifier.toString());
        }
        this.modifier = modifier;
        this.head = head;
        this.relation = rel;
    }

    public CollinsRelation getRelation() {
        return this.relation;
    }

    @Override
    public DependencyFactory dependencyFactory() {
        return null;
    }

    @Override
    public CoreLabel dependent() {
        return this.modifier;
    }

    @Override
    public CoreLabel governor() {
        return this.head;
    }

    @Override
    public boolean equalsIgnoreName(Object o) {
        return this.equals(o);
    }

    @Override
    public String name() {
        return "CollinsBilexicalDependency";
    }

    @Override
    public String toString(String format) {
        return this.toString();
    }

    private static CoreLabel makeStartLabel(String label) {
        CoreLabel root = new CoreLabel();
        root.set(CoreAnnotations.ValueAnnotation.class, label);
        root.set(CoreAnnotations.IndexAnnotation.class, 0);
        return root;
    }

    public static Set<CollinsDependency> extractFromTree(Tree t, String startSymbol, HeadFinder hf) {
        return CollinsDependency.extractFromTree(t, startSymbol, hf, false);
    }

    public static Set<CollinsDependency> extractNormalizedFromTree(Tree t, String startSymbol, HeadFinder hf) {
        return CollinsDependency.extractFromTree(t, startSymbol, hf, true);
    }

    private static Set<CollinsDependency> extractFromTree(Tree t, String startSymbol, HeadFinder hf, boolean normPOS) {
        if (t == null || startSymbol.equals("") || hf == null) {
            return null;
        }
        Set<CollinsDependency> deps = Generics.newHashSet();
        if (t.value().equals(startSymbol)) {
            t = t.firstChild();
        }
        boolean mustProcessRoot = true;
        for (Tree node : t) {
            if (node.isLeaf() || node.numChildren() < 2) continue;
            Tree headDaughter = hf.determineHead(node);
            Tree head = node.headTerminal(hf);
            if (headDaughter == null || head == null) {
                log.info("WARNING: CollinsDependency.extractFromTree() could not find root for:\n" + node.pennString());
                continue;
            }
            if (mustProcessRoot) {
                mustProcessRoot = false;
                CoreLabel startLabel = CollinsDependency.makeStartLabel(startSymbol);
                deps.add(new CollinsDependency(new CoreLabel(head.label()), startLabel, new CollinsRelation(startSymbol, startSymbol, node.value(), CollinsRelation.Direction.Right)));
            }
            CollinsRelation.Direction dir = CollinsRelation.Direction.Left;
            for (Tree daughter : node.children()) {
                if (daughter.equals(headDaughter)) {
                    dir = CollinsRelation.Direction.Right;
                    continue;
                }
                Tree headOfDaughter = daughter.headTerminal(hf);
                String relParent = normPOS && node.isPreTerminal() ? normPOSLabel : node.value();
                String relHead = normPOS && headDaughter.isPreTerminal() ? normPOSLabel : headDaughter.value();
                String relModifier = normPOS && daughter.isPreTerminal() ? normPOSLabel : daughter.value();
                CollinsDependency newDep = new CollinsDependency(new CoreLabel(headOfDaughter.label()), new CoreLabel(head.label()), new CollinsRelation(relParent, relHead, relModifier, dir));
                deps.add(newDep);
            }
        }
        if (t.yield().size() != deps.size()) {
            System.err.printf("WARNING: Number of extracted dependencies (%d) does not match yield (%d):\n", deps.size(), t.yield().size());
            log.info(t.pennString());
            log.info(new Object[0]);
            int num = 0;
            for (CollinsDependency dep : deps) {
                log.info(num++ + ": " + dep.toString());
            }
        }
        return deps;
    }

    public String toString() {
        return String.format("%s (%d)   %s (%d)  <%s>", this.modifier.value(), this.modifier.index(), this.head.value(), this.head.index(), this.relation.toString());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CollinsDependency)) {
            return false;
        }
        CollinsDependency otherDep = (CollinsDependency)other;
        return this.modifier.equals(otherDep.modifier) && this.head.equals(otherDep.head) && this.relation.equals(otherDep.relation);
    }

    public int hashCode() {
        int hash = 1;
        hash *= 31 + this.modifier.index();
        return hash *= 138 * this.head.value().hashCode();
    }
}

