/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.CopulaHeadFinder;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

public abstract class AbstractCollinsHeadFinder
implements HeadFinder,
CopulaHeadFinder {
    private static Redwood.RedwoodChannels log = Redwood.channels(AbstractCollinsHeadFinder.class);
    private static final boolean DEBUG = System.getProperty("HeadFinder", null) != null;
    protected final TreebankLanguagePack tlp;
    protected Map<String, String[][]> nonTerminalInfo;
    protected String[] defaultRule;
    protected String[] defaultLeftRule;
    protected String[] defaultRightRule;
    private static final long serialVersionUID = -6540278059442931087L;

    protected AbstractCollinsHeadFinder(TreebankLanguagePack tlp, String ... categoriesToAvoid) {
        this.tlp = tlp;
        this.defaultLeftRule = new String[categoriesToAvoid.length + 1];
        this.defaultRightRule = new String[categoriesToAvoid.length + 1];
        if (categoriesToAvoid.length > 0) {
            this.defaultLeftRule[0] = "leftexcept";
            this.defaultRightRule[0] = "rightexcept";
            System.arraycopy(categoriesToAvoid, 0, this.defaultLeftRule, 1, categoriesToAvoid.length);
            System.arraycopy(categoriesToAvoid, 0, this.defaultRightRule, 1, categoriesToAvoid.length);
        } else {
            this.defaultLeftRule[0] = "left";
            this.defaultRightRule[0] = "right";
        }
    }

    @Override
    public boolean makesCopulaHead() {
        return false;
    }

    protected Tree findMarkedHead(Tree t) {
        return null;
    }

    @Override
    public Tree determineHead(Tree t) {
        return this.determineHead(t, null);
    }

    @Override
    public Tree determineHead(Tree t, Tree parent) {
        if (this.nonTerminalInfo == null) {
            throw new IllegalStateException("Classes derived from AbstractCollinsHeadFinder must create and fill HashMap nonTerminalInfo.");
        }
        if (t == null || t.isLeaf()) {
            throw new IllegalArgumentException("Can't return head of null or leaf Tree.");
        }
        if (DEBUG) {
            log.info("determineHead for " + t.value());
        }
        Tree[] kids = t.children();
        Tree theHead = this.findMarkedHead(t);
        if (theHead != null) {
            if (DEBUG) {
                log.info("Find marked head method returned " + theHead.label() + " as head of " + t.label());
            }
            return theHead;
        }
        if (kids.length == 1) {
            if (DEBUG) {
                log.info("Only one child determines " + kids[0].label() + " as head of " + t.label());
            }
            return kids[0];
        }
        return this.determineNonTrivialHead(t, parent);
    }

    protected Tree determineNonTrivialHead(Tree t, Tree parent) {
        boolean lastResort;
        Tree theHead = null;
        String motherCat = this.tlp.basicCategory(t.label().value());
        if (motherCat.startsWith("@")) {
            motherCat = motherCat.substring(1);
        }
        if (DEBUG) {
            log.info("Looking for head of " + t.label() + "; value is |" + t.label().value() + "|,  baseCat is |" + motherCat + '|');
        }
        String[][] how = this.nonTerminalInfo.get(motherCat);
        Tree[] kids = t.children();
        if (how == null) {
            if (DEBUG) {
                log.info("Warning: No rule found for " + motherCat + " (first char: " + motherCat.charAt(0) + ')');
                log.info("Known nonterms are: " + this.nonTerminalInfo.keySet());
            }
            if (this.defaultRule != null) {
                if (DEBUG) {
                    log.info("  Using defaultRule");
                }
                return this.traverseLocate(kids, this.defaultRule, true);
            }
            TreePrint printer = new TreePrint("penn");
            StringWriter buffer = new StringWriter();
            printer.printTree(t, new PrintWriter(buffer));
            throw new IllegalArgumentException("No head rule defined for " + motherCat + " using " + this.getClass() + " in " + buffer.toString());
        }
        for (int i = 0; i < how.length && (theHead = this.traverseLocate(kids, how[i], lastResort = i == how.length - 1)) == null; ++i) {
        }
        if (DEBUG) {
            log.info("  Chose " + theHead.label());
        }
        return theHead;
    }

    protected Tree traverseLocate(Tree[] daughterTrees, String[] how, boolean lastResort) {
        int headIdx;
        switch (how[0]) {
            case "left": {
                headIdx = this.findLeftHead(daughterTrees, how);
                break;
            }
            case "leftdis": {
                headIdx = this.findLeftDisHead(daughterTrees, how);
                break;
            }
            case "leftexcept": {
                headIdx = this.findLeftExceptHead(daughterTrees, how);
                break;
            }
            case "right": {
                headIdx = this.findRightHead(daughterTrees, how);
                break;
            }
            case "rightdis": {
                headIdx = this.findRightDisHead(daughterTrees, how);
                break;
            }
            case "rightexcept": {
                headIdx = this.findRightExceptHead(daughterTrees, how);
                break;
            }
            default: {
                throw new IllegalStateException("ERROR: invalid direction type " + how[0] + " to nonTerminalInfo map in AbstractCollinsHeadFinder.");
            }
        }
        if (headIdx < 0) {
            if (lastResort) {
                String[] rule;
                if (how[0].startsWith("left")) {
                    headIdx = 0;
                    rule = this.defaultLeftRule;
                } else {
                    headIdx = daughterTrees.length - 1;
                    rule = this.defaultRightRule;
                }
                Tree child = this.traverseLocate(daughterTrees, rule, false);
                if (child != null) {
                    return child;
                }
                return daughterTrees[headIdx];
            }
            return null;
        }
        headIdx = this.postOperationFix(headIdx, daughterTrees);
        return daughterTrees[headIdx];
    }

    private int findLeftHead(Tree[] daughterTrees, String[] how) {
        for (int i = 1; i < how.length; ++i) {
            for (int headIdx = 0; headIdx < daughterTrees.length; ++headIdx) {
                String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                if (!how[i].equals(childCat)) continue;
                return headIdx;
            }
        }
        return -1;
    }

    private int findLeftDisHead(Tree[] daughterTrees, String[] how) {
        for (int headIdx = 0; headIdx < daughterTrees.length; ++headIdx) {
            String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
            for (int i = 1; i < how.length; ++i) {
                if (!how[i].equals(childCat)) continue;
                return headIdx;
            }
        }
        return -1;
    }

    private int findLeftExceptHead(Tree[] daughterTrees, String[] how) {
        for (int headIdx = 0; headIdx < daughterTrees.length; ++headIdx) {
            String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
            boolean found = true;
            for (int i = 1; i < how.length; ++i) {
                if (!how[i].equals(childCat)) continue;
                found = false;
            }
            if (!found) continue;
            return headIdx;
        }
        return -1;
    }

    private int findRightHead(Tree[] daughterTrees, String[] how) {
        for (int i = 1; i < how.length; ++i) {
            for (int headIdx = daughterTrees.length - 1; headIdx >= 0; --headIdx) {
                String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                if (!how[i].equals(childCat)) continue;
                return headIdx;
            }
        }
        return -1;
    }

    private int findRightDisHead(Tree[] daughterTrees, String[] how) {
        for (int headIdx = daughterTrees.length - 1; headIdx >= 0; --headIdx) {
            String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
            for (int i = 1; i < how.length; ++i) {
                if (!how[i].equals(childCat)) continue;
                return headIdx;
            }
        }
        return -1;
    }

    private int findRightExceptHead(Tree[] daughterTrees, String[] how) {
        for (int headIdx = daughterTrees.length - 1; headIdx >= 0; --headIdx) {
            String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
            boolean found = true;
            for (int i = 1; i < how.length; ++i) {
                if (!how[i].equals(childCat)) continue;
                found = false;
            }
            if (!found) continue;
            return headIdx;
        }
        return -1;
    }

    protected int postOperationFix(int headIdx, Tree[] daughterTrees) {
        return headIdx;
    }
}

