/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time.suservlet;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.time.Options;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.time.suservlet.SUTimePipeline;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;

public class SUTimeServlet
extends HttpServlet {
    private SUTimePipeline pipeline;
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
        String dataDir = this.getServletContext().getRealPath("/WEB-INF/data");
        String taggerFilename = dataDir + "/english-left3words-distsim.tagger";
        Properties pipelineProps = new Properties();
        pipelineProps.setProperty("pos.model", taggerFilename);
        this.pipeline = new SUTimePipeline(pipelineProps);
        System.setProperty("de.jollyday.config", this.getServletContext().getRealPath("/WEB-INF/classes/holidays/jollyday.properties"));
    }

    public static boolean parseBoolean(String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            return false;
        }
        if (value.equalsIgnoreCase("on")) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("utf-8");
        }
        response.setContentType("text/html; charset=UTF-8");
        this.getServletContext().getRequestDispatcher("/header.jsp").include((ServletRequest)request, (ServletResponse)response);
        this.addResults(request, response);
        this.getServletContext().getRequestDispatcher("/footer.jsp").include((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getRuleFilepaths(String ... files) {
        String rulesDir = this.getServletContext().getRealPath("/WEB-INF/data/rules");
        StringBuilder sb = new StringBuilder();
        for (String file : files) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(rulesDir + "/" + file);
        }
        return sb.toString();
    }

    private Properties getTimeAnnotatorProperties(HttpServletRequest request) {
        String rules;
        boolean markTimeRanges = SUTimeServlet.parseBoolean(request.getParameter("markTimeRanges"));
        boolean includeNested = SUTimeServlet.parseBoolean(request.getParameter("includeNested"));
        boolean includeRange = SUTimeServlet.parseBoolean(request.getParameter("includeRange"));
        boolean readRules = true;
        String heuristicLevel = request.getParameter("relativeHeuristicLevel");
        Options.RelativeHeuristicLevel relativeHeuristicLevel = Options.RelativeHeuristicLevel.NONE;
        if (!StringUtils.isNullOrEmpty(heuristicLevel)) {
            relativeHeuristicLevel = Options.RelativeHeuristicLevel.valueOf(heuristicLevel);
        }
        String ruleFile = null;
        if (readRules && "English".equalsIgnoreCase(rules = request.getParameter("rules"))) {
            ruleFile = this.getRuleFilepaths("defs.sutime.txt", "english.sutime.txt", "english.holidays.sutime.txt");
        }
        Properties props = new Properties();
        if (markTimeRanges) {
            props.setProperty("sutime.markTimeRanges", "true");
        }
        if (includeNested) {
            props.setProperty("sutime.includeNested", "true");
        }
        if (includeRange) {
            props.setProperty("sutime.includeRange", "true");
        }
        if (ruleFile != null) {
            props.setProperty("sutime.rules", ruleFile);
            props.setProperty("sutime.binders", "1");
            props.setProperty("sutime.binder.1", "edu.stanford.nlp.time.JollyDayHolidays");
            props.setProperty("sutime.binder.1.xml", this.getServletContext().getRealPath("/WEB-INF/data/holidays/Holidays_sutime.xml"));
            props.setProperty("sutime.binder.1.pathtype", "file");
        }
        props.setProperty("sutime.teRelHeurLevel", relativeHeuristicLevel.toString());
        return props;
    }

    private static void displayAnnotation(PrintWriter out2, String query, Annotation anno, boolean includeOffsets) {
        List timexAnns = (List)anno.get(TimeAnnotations.TimexAnnotations.class);
        ArrayList<String> pieces = new ArrayList<String>();
        ArrayList<Boolean> tagged = new ArrayList<Boolean>();
        int previousEnd = 0;
        for (CoreMap timexAnn : timexAnns) {
            int begin = (Integer)timexAnn.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int end = (Integer)timexAnn.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            if (begin < previousEnd) continue;
            pieces.add(query.substring(previousEnd, begin));
            tagged.add(false);
            pieces.add(query.substring(begin, end));
            tagged.add(true);
            previousEnd = end;
        }
        if (previousEnd < query.length()) {
            pieces.add(query.substring(previousEnd));
            tagged.add(false);
        }
        out2.println("<table id='Annotated'><tr><td>");
        for (int i = 0; i < pieces.size(); ++i) {
            if (((Boolean)tagged.get(i)).booleanValue()) {
                out2.print("<span style=\"background-color: #FF8888\">");
                out2.print(StringEscapeUtils.escapeHtml4((String)((String)pieces.get(i))));
                out2.print("</span>");
                continue;
            }
            out2.print(StringEscapeUtils.escapeHtml4((String)((String)pieces.get(i))));
        }
        out2.println("</td></tr></table>");
        out2.println("<h3>Temporal Expressions</h3>");
        if (timexAnns.size() > 0) {
            out2.println("<table>");
            out2.println("<tr><th>Text</th><th>Value</th>");
            if (includeOffsets) {
                out2.println("<th>Char Begin</th><th>Char End</th><th>Token Begin</th><th>Token End</th>");
            }
            out2.println("<th>Timex3 Tag</th></tr>");
            for (CoreMap timexAnn : timexAnns) {
                out2.println("<tr>");
                Timex timex = (Timex)timexAnn.get(TimeAnnotations.TimexAnnotation.class);
                int begin = (Integer)timexAnn.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int end = (Integer)timexAnn.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                out2.print("<td>" + StringEscapeUtils.escapeHtml4((String)query.substring(begin, end)) + "</td>");
                out2.print("<td>" + (timex.value() != null ? StringEscapeUtils.escapeHtml4((String)timex.value()) : "") + "</td>");
                if (includeOffsets) {
                    out2.print("<td>" + begin + "</td>");
                    out2.print("<td>" + end + "</td>");
                    out2.print("<td>" + timexAnn.get(CoreAnnotations.TokenBeginAnnotation.class) + "</td>");
                    out2.print("<td>" + timexAnn.get(CoreAnnotations.TokenEndAnnotation.class) + "</td>");
                }
                out2.print("<td>" + StringEscapeUtils.escapeHtml4((String)timex.toString()) + "</td>");
                out2.println("</tr>");
            }
            out2.println("</table>");
        } else {
            out2.println("<em>No temporal expressions.</em>");
        }
        out2.println("<h3>POS Tags</h3>");
        out2.println("<table><tr><td>");
        for (CoreMap sentence : (List)anno.get(CoreAnnotations.SentencesAnnotation.class)) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            for (CoreLabel token : tokens) {
                String tokenOutput = StringEscapeUtils.escapeHtml4((String)(token.word() + "/" + token.tag()));
                out2.print(tokenOutput + " ");
            }
            out2.println("<br>");
        }
        out2.println("</td></tr></table>");
    }

    private void addResults(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String query = request.getParameter("q");
        String dateString = request.getParameter("d");
        boolean dateError = !this.pipeline.isDateOkay(dateString);
        boolean includeOffsets = SUTimeServlet.parseBoolean(request.getParameter("includeOffsets"));
        PrintWriter out2 = response.getWriter();
        if (dateError) {
            out2.println("<br><br>Warning: unparseable date " + StringEscapeUtils.escapeHtml4((String)dateString));
        }
        if (!StringUtils.isNullOrEmpty(query)) {
            Annotator timeAnnotator;
            Properties props = this.getTimeAnnotatorProperties(request);
            String annotatorType = request.getParameter("annotator");
            if (annotatorType == null) {
                annotatorType = "sutime";
            }
            if ((timeAnnotator = this.pipeline.getTimeAnnotator(annotatorType, props)) != null) {
                Annotation anno = this.pipeline.process(query, dateString, timeAnnotator);
                out2.println("<h3>Annotated Text</h3> <em>(tagged using " + annotatorType + "</em>)");
                SUTimeServlet.displayAnnotation(out2, query, anno, includeOffsets);
            } else {
                out2.println("<br><br>Error creating annotator for " + StringEscapeUtils.escapeHtml4((String)annotatorType));
            }
        }
    }
}

