/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class HeidelTimeTest {
    @Test
    public void runHeidelTimeEnglish() throws Exception {
        String text = "On Monday, some cataclysmic news about a a release last Christmas was released.";
        Annotation ann = new Annotation(text);
        String date = "2017-07-07";
        ann.set(CoreAnnotations.DocDateAnnotation.class, date);
        Properties defaultProps = new Properties();
        defaultProps.load(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP.properties"));
        Properties props = new Properties(defaultProps);
        props.setProperty("customAnnotatorClass.heideltime", "edu.stanford.nlp.time.HeidelTimeAnnotator");
        props.setProperty("heideltime.path", System.getenv("HEIDELTIME_PATH"));
        props.setProperty("heideltime.language", "english");
        props.setProperty("annotators", "tokenize,ssplit,heideltime");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(ann);
        List outputs = (List)ann.get(TimeAnnotations.TimexAnnotations.class);
        Assert.assertEquals((long)2L, (long)outputs.size());
        Assert.assertEquals((Object)"Monday", (Object)((Timex)((CoreMap)outputs.get(0)).get(TimeAnnotations.TimexAnnotation.class)).text());
        Assert.assertEquals((Object)"2017-07-03", (Object)((Timex)((CoreMap)outputs.get(0)).get(TimeAnnotations.TimexAnnotation.class)).value());
        Assert.assertEquals((Object)"Christmas", (Object)((Timex)((CoreMap)outputs.get(1)).get(TimeAnnotations.TimexAnnotation.class)).text());
        Assert.assertEquals((Object)"2016-12-25", (Object)((Timex)((CoreMap)outputs.get(1)).get(TimeAnnotations.TimexAnnotation.class)).value());
    }

    @Test
    public void runHeidelTimeSpanish() throws Exception {
        String text = "El lunes, algunas noticias catacl\u00edsmicas sobre un lanzamiento de la Navidad pasada fueron liberadas.";
        Annotation ann = new Annotation(text);
        String date = "2017-07-07";
        ann.set(CoreAnnotations.DocDateAnnotation.class, date);
        Properties defaultProps = new Properties();
        defaultProps.load(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-spanish.properties"));
        Properties props = new Properties(defaultProps);
        props.setProperty("customAnnotatorClass.heideltime", "edu.stanford.nlp.time.HeidelTimeAnnotator");
        props.setProperty("heideltime.path", System.getenv("HEIDELTIME_PATH"));
        props.setProperty("heideltime.language", "spanish");
        props.setProperty("annotators", "tokenize,ssplit,heideltime");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(ann);
        List outputs = (List)ann.get(TimeAnnotations.TimexAnnotations.class);
        Assert.assertEquals((long)1L, (long)outputs.size());
        Assert.assertEquals((Object)"El lunes", (Object)((Timex)((CoreMap)outputs.get(0)).get(TimeAnnotations.TimexAnnotation.class)).text());
        Assert.assertEquals((Object)"2017-07-03", (Object)((Timex)((CoreMap)outputs.get(0)).get(TimeAnnotations.TimexAnnotation.class)).value());
    }
}

