/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.CoreEntityMention;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class HeidelTimeKBPAnnotatorITest
extends TestCase {
    public StanfordCoreNLP pipeline;
    public String WORKING_DIR = "/u/scr/nlp/data/stanford-corenlp-testing/spanish-heideltime";
    public Set<String> GOLD_RESULTS = new HashSet<String>(Arrays.asList("Rusia\tCOUNTRY", "Jap\u00f3n\tCOUNTRY", "hoy\tDATE", "rusa\tLOCATION", "Vicente Fox\tPERSON", "el 2 de julio de 1942\tDATE", "Esta semana\tDATE", "ING\tORGANIZATION", "14\tNUMBER", "12\tNUMBER"));

    public void setUp() {
        Properties props = StringUtils.argsToProperties("-props", this.WORKING_DIR + "/test.props");
        this.pipeline = new StanfordCoreNLP(props);
    }

    public void testHeidelTimeKBPAnnotatorITest() {
        String testFileContents = IOUtils.stringFromFile(this.WORKING_DIR + "/example-sentences.txt");
        CoreDocument testDocument = new CoreDocument(testFileContents);
        this.pipeline.annotate(testDocument);
        HashSet<String> outputResults = new HashSet<String>();
        for (CoreEntityMention em : testDocument.entityMentions()) {
            outputResults.add(em.text() + "\t" + em.entityType());
        }
        HeidelTimeKBPAnnotatorITest.assertEquals(this.GOLD_RESULTS, outputResults);
    }
}

