/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;

class ExtractorLetterDashDigit
extends RareExtractor {
    private static final long serialVersionUID = 33L;

    @Override
    String extract(History h, PairsHolder pH) {
        String s = pH.getWord(h, 0);
        if (s == null) {
            return "0";
        }
        boolean seenLetter = false;
        boolean seenDash = false;
        boolean seenNumber = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (Character.isLetter(ch)) {
                seenLetter = true;
                continue;
            }
            if (seenLetter && ch == '-') {
                seenDash = true;
                continue;
            }
            if (!seenDash || !Character.isDigit(ch)) continue;
            seenNumber = true;
            break;
        }
        if (seenNumber) {
            return "1";
        }
        return "0";
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

