/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.ProbabilityDistribution;
import java.util.Random;

public class Gamma
implements ProbabilityDistribution<Double> {
    private static final long serialVersionUID = -2992079318379176178L;
    public final double alpha;

    public Gamma(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public Double drawSample(Random random) {
        return Gamma.drawSample(random, this.alpha);
    }

    public static Double drawSample(Random random, double alpha) {
        double vv;
        double zz;
        double uu;
        double ww;
        double yy;
        double xx;
        if (alpha <= 0.0) {
            return 0.0;
        }
        if (alpha == 1.0) {
            return -Math.log(Math.random());
        }
        if (alpha < 1.0) {
            double xx2;
            double yy2;
            double cc = 1.0 / alpha;
            double dd = 1.0 / (1.0 - alpha);
            while (!((yy2 = (xx2 = Math.pow(Math.random(), cc)) + Math.pow(Math.random(), dd)) <= 1.0)) {
            }
            return -Math.log(Math.random()) * xx2 / yy2;
        }
        double bb = alpha - 1.0;
        double cc = 3.0 * alpha - 0.75;
        do {
            uu = Math.random();
            vv = Math.random();
        } while (!((xx = bb + (yy = Math.sqrt(cc / (ww = uu * (1.0 - uu))) * (uu - 0.5))) >= 0.0) || !((zz = 64.0 * ww * ww * ww * vv * vv) <= 1.0 - 2.0 * yy * yy / xx) && !(Math.log(zz) <= 2.0 * (bb * Math.log(xx / bb) - yy)));
        return xx;
    }

    public static double drawSample(Random r, double a, double b) {
        return Gamma.drawSample(r, a) * b;
    }

    @Override
    public double probabilityOf(Double x) {
        return 0.0;
    }

    @Override
    public double logProbabilityOf(Double x) {
        return 0.0;
    }

    public int hashCode() {
        return new Double(this.alpha).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Gamma)) {
            return false;
        }
        return ((Gamma)o).alpha == this.alpha;
    }
}

