/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.Distribution;
import junit.framework.TestCase;

public class DistributionTest
extends TestCase {
    public void testGetDistributionFromLogValues() {
        ClassicCounter<String> c1 = new ClassicCounter<String>();
        c1.setCount("p", 1.0);
        c1.setCount("q", 2.0);
        c1.setCount("r", 3.0);
        c1.setCount("s", 4.0);
        Counters.logInPlace(c1);
        Distribution<String> distribution = Distribution.getDistributionFromLogValues(c1);
        DistributionTest.assertEquals((int)distribution.keySet().size(), (int)4);
        DistributionTest.assertEquals((boolean)distribution.containsKey("p"), (boolean)true);
        DistributionTest.assertEquals((boolean)distribution.containsKey("q"), (boolean)true);
        DistributionTest.assertEquals((boolean)distribution.containsKey("r"), (boolean)true);
        DistributionTest.assertEquals((boolean)distribution.containsKey("s"), (boolean)true);
        DistributionTest.assertEquals((double)distribution.getCount("p"), (double)0.1, (double)1.0E-10);
        DistributionTest.assertEquals((double)distribution.getCount("q"), (double)0.2, (double)1.0E-10);
        DistributionTest.assertEquals((double)distribution.getCount("r"), (double)0.3, (double)1.0E-10);
        DistributionTest.assertEquals((double)distribution.getCount("s"), (double)0.4, (double)1.0E-10);
    }
}

