/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.semgraph.semgrex.ssurgeon.Ssurgeon;
import java.io.StringWriter;
import java.util.HashSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SsurgeonWordlist {
    private static final String WORD_ELT = "word";
    private String id;
    private HashSet<String> words = new HashSet();

    public String toString() {
        StringWriter buf = new StringWriter();
        buf.write("Ssurgeon Wordlist Resource, id=");
        buf.write(this.id);
        buf.write(", elements=(");
        for (String word : this.words) {
            buf.write(" ");
            buf.write(word);
        }
        buf.write(")");
        return buf.toString();
    }

    public String getID() {
        return this.id;
    }

    public SsurgeonWordlist(Element rootElt) {
        this.id = rootElt.getAttribute("id");
        NodeList wordEltNL = rootElt.getElementsByTagName(WORD_ELT);
        for (int i = 0; i < wordEltNL.getLength(); ++i) {
            Node node = wordEltNL.item(i);
            if (node.getNodeType() != 1) continue;
            String word = Ssurgeon.getEltText((Element)node);
            this.words.add(word);
        }
    }

    public boolean contains(String testWord) {
        return this.words.contains(testWord);
    }

    public static void main(String[] args) {
    }
}

