/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphUtils;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddDep;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddEdge;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddNode;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.DeleteGraphFromNode;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.KillAllIncomingEdges;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.KillNonRootedNodes;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.RemoveEdge;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.RemoveNamedEdge;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SetRoots;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonPattern;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonWordlist;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.pred.SsurgAndPred;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.pred.SsurgOrPred;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.pred.SsurgPred;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.pred.WordlistTest;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Ssurgeon {
    private static final boolean VERBOSE = false;
    private static Ssurgeon instance = null;
    private static final Redwood.RedwoodChannels log = Redwood.channels(Ssurgeon.class);
    private String logPrefix = null;
    private Map<String, SsurgeonWordlist> wordListResources = Generics.newHashMap();
    public static final String GOV_NODENAME_ARG = "-gov";
    public static final String DEP_NODENAME_ARG = "-dep";
    public static final String EDGE_NAME_ARG = "-edge";
    public static final String NODENAME_ARG = "-node";
    public static final String RELN_ARG = "-reln";
    public static final String NODE_PROTO_ARG = "-nodearg";
    public static final String WEIGHT_ARG = "-weight";
    public static final String NAME_ARG = "-name";
    protected static ArgsBox argsBox = new ArgsBox();

    private Ssurgeon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ssurgeon inst() {
        Class<Ssurgeon> clazz = Ssurgeon.class;
        synchronized (Ssurgeon.class) {
            if (instance == null) {
                instance = new Ssurgeon();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initLog(File logFilePath) throws IOException {
        RedwoodConfiguration.empty().handlers(RedwoodConfiguration.Handlers.chain(RedwoodConfiguration.Handlers.showAllChannels(), RedwoodConfiguration.Handlers.stderr), RedwoodConfiguration.Handlers.file(logFilePath.toString())).apply();
        System.out.println("Starting Ssurgeon log, at " + logFilePath.getAbsolutePath() + " date=" + DateFormat.getDateInstance(0).format(new Date()));
        log.info("Starting Ssurgeon log, date=" + DateFormat.getDateInstance(0).format(new Date()));
    }

    public void setLogPrefix(String logPrefix) {
        this.logPrefix = logPrefix;
    }

    public List<SemanticGraph> expandFromPatterns(List<SsurgeonPattern> patternList, SemanticGraph sg) throws Exception {
        ArrayList<SemanticGraph> retList = new ArrayList<SemanticGraph>();
        for (SsurgeonPattern pattern : patternList) {
            Collection<SemanticGraph> generated = pattern.execute(sg);
            for (SemanticGraph orderedGraph : generated) {
                retList.add(orderedGraph);
                System.out.println("\ncompact = " + orderedGraph.toCompactString());
                System.out.println("regular=" + orderedGraph);
            }
            if (generated.size() <= 0) continue;
            if (log != null) {
                log.info("* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
                log.info("Pre remove duplicates, num=" + generated.size());
            }
            SemanticGraphUtils.removeDuplicates(generated, sg);
            if (log == null) continue;
            log.info("Expand from patterns");
            if (this.logPrefix != null) {
                log.info(this.logPrefix);
            }
            log.info("Pattern = '" + pattern.getUID() + "' generated " + generated.size() + " matches");
            log.info("= = = = = = = = = =\nSrc graph:\n" + sg + "\n= = = = = = = = = =\n");
            int index = 1;
            for (SemanticGraph genSg : generated) {
                log.info("REWRITE " + index++);
                log.info(genSg.toString());
                log.info(". . . . .\n");
            }
        }
        return retList;
    }

    public Collection<SemanticGraph> exhaustFromPatterns(List<SsurgeonPattern> patternList, SemanticGraph sg) throws Exception {
        Collection<SemanticGraph> generated = this.exhaustFromPatterns(patternList, sg, 1);
        if (generated.size() > 1) {
            if (log != null) {
                log.info("Before remove dupe, size=" + generated.size());
            }
            generated = SemanticGraphUtils.removeDuplicates(generated, sg);
            if (log != null) {
                log.info("AFTER remove dupe, size=" + generated.size());
            }
        }
        return generated;
    }

    private List<SemanticGraph> exhaustFromPatterns(List<SsurgeonPattern> patternList, SemanticGraph sg, int depth) throws Exception {
        ArrayList<SemanticGraph> retList = new ArrayList<SemanticGraph>();
        for (SsurgeonPattern pattern : patternList) {
            Collection<SemanticGraph> generated = pattern.execute(sg);
            for (SemanticGraph modGraph : generated) {
                retList.add(modGraph);
            }
            if (log == null || generated.size() <= 0) continue;
            log.info("* * * * * * * * * ** * * * * * * * * *");
            log.info("Exhaust from patterns, depth=" + depth);
            if (this.logPrefix != null) {
                log.info(this.logPrefix);
            }
            log.info("Pattern = '" + pattern.getUID() + "' generated " + generated.size() + " matches");
            log.info("= = = = = = = = = =\nSrc graph:\n" + sg.toString() + "\n= = = = = = = = = =\n");
            int index = 1;
            for (SemanticGraph genSg : generated) {
                log.info("REWRITE " + index++);
                log.info(genSg.toString());
                log.info(". . . . .\n");
            }
        }
        if (retList.size() > 0) {
            ArrayList<SemanticGraph> referenceList = new ArrayList<SemanticGraph>(retList);
            for (SemanticGraph childGraph : referenceList) {
                if (depth >= 3) continue;
                retList.addAll(this.exhaustFromPatterns(patternList, childGraph, depth + 1));
            }
        }
        return retList;
    }

    public static SsurgeonPattern getOperationFromFile(String path) {
        return null;
    }

    private void addResource(SsurgeonWordlist resource) {
        this.wordListResources.put(resource.getID(), resource);
    }

    public SsurgeonWordlist getResource(String id) {
        return this.wordListResources.get(id);
    }

    public Collection<SsurgeonWordlist> getResources() {
        return this.wordListResources.values();
    }

    private static String[] parseArgs(String argsString) {
        ArrayList<String> retList = new ArrayList<String>();
        String patternString = "(?:[^\\s\\\"]++|\\\"[^\\\"]*+\\\"|(\\\"))++";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(argsString);
        while (matcher.find()) {
            if (matcher.group(1) == null) {
                String matched = matcher.group();
                if (matched.charAt(0) == '\"' && matched.charAt(matched.length() - 1) == '\"') {
                    retList.add(matched.substring(1, matched.length() - 1));
                    continue;
                }
                retList.add(matched);
                continue;
            }
            throw new IllegalArgumentException("Unmatched quote in string to parse");
        }
        return retList.toArray(StringUtils.EMPTY_STRING_ARRAY);
    }

    public static SsurgeonEdit parseEditLine(String editLine) {
        SsurgeonEdit retEdit;
        String[] tuples1 = editLine.split("\\s+", 2);
        if (tuples1.length < 2) {
            throw new IllegalArgumentException("Error in SsurgeonEdit.parseEditLine: invalid number of arguments");
        }
        String command = tuples1[0];
        String[] argsArray = Ssurgeon.parseArgs(tuples1[1]);
        SsurgeonArgs argsBox = new SsurgeonArgs();
        block20: for (int argIndex = 0; argIndex < argsArray.length; ++argIndex) {
            switch (argsArray[argIndex]) {
                case "-gov": {
                    argsBox.govNodeName = argsArray[argIndex + 1];
                    argIndex += 2;
                    continue block20;
                }
                case "-dep": {
                    argsBox.dep = argsArray[argIndex + 1];
                    argIndex += 2;
                    continue block20;
                }
                case "-edge": {
                    argsBox.edge = argsArray[argIndex + 1];
                    argIndex += 2;
                    continue block20;
                }
                case "-reln": {
                    argsBox.reln = argsArray[argIndex + 1];
                    argIndex += 2;
                    continue block20;
                }
                case "-node": {
                    argsBox.node = argsArray[argIndex + 1];
                    argIndex += 2;
                    continue block20;
                }
                case "-nodearg": {
                    argsBox.nodeString = argsArray[argIndex + 1];
                    argIndex += 2;
                    continue block20;
                }
                case "-weight": {
                    argsBox.weight = Double.valueOf(argsArray[argIndex + 1]);
                    argIndex += 2;
                    continue block20;
                }
                case "-name": {
                    argsBox.name = argsArray[argIndex + 1];
                    argIndex += 2;
                    continue block20;
                }
                default: {
                    throw new IllegalArgumentException("Parsing Ssurgeon args: unknown flag " + argsArray[argIndex]);
                }
            }
        }
        if (command.equalsIgnoreCase("addDep")) {
            retEdit = AddDep.createEngAddDep(argsBox.govNodeName, argsBox.reln, argsBox.nodeString);
        } else if (command.equalsIgnoreCase("addNode")) {
            retEdit = AddNode.createAddNode(argsBox.nodeString, argsBox.name);
        } else if (command.equalsIgnoreCase("addEdge")) {
            retEdit = AddEdge.createEngAddEdge(argsBox.govNodeName, argsBox.dep, argsBox.reln);
        } else if (command.equalsIgnoreCase("delete")) {
            retEdit = new DeleteGraphFromNode(argsBox.node);
        } else if (command.equalsIgnoreCase("removeEdge")) {
            retEdit = new RemoveEdge(GrammaticalRelation.valueOf(argsBox.reln), argsBox.govNodeName, argsBox.dep);
        } else if (command.equalsIgnoreCase("removeNamedEdge")) {
            retEdit = new RemoveNamedEdge(argsBox.edge, argsBox.govNodeName, argsBox.dep);
        } else if (command.equalsIgnoreCase("setRoots")) {
            String[] names = tuples1[1].split("\\s+");
            List<String> newRoots = Arrays.asList(names);
            retEdit = new SetRoots(newRoots);
        } else if (command.equalsIgnoreCase("killNonRooted")) {
            retEdit = new KillNonRootedNodes();
        } else if (command.equalsIgnoreCase("killAllIncomingEdges")) {
            retEdit = new KillAllIncomingEdges(argsBox.node);
        } else {
            throw new IllegalArgumentException("Error in SsurgeonEdit.parseEditLine: command '" + command + "' is not supported");
        }
        return retEdit;
    }

    public static void writeToFile(File tgtFile, List<SsurgeonPattern> patterns) {
        try {
            Document domDoc = Ssurgeon.createPatternXMLDoc(patterns);
            if (domDoc != null) {
                Transformer tformer = TransformerFactory.newInstance().newTransformer();
                tformer.setOutputProperty("indent", "yes");
                tformer.transform(new DOMSource(domDoc), new StreamResult(tgtFile));
            } else {
                log.warning("Was not able to create XML document for pattern list, file not written.");
            }
        }
        catch (Exception e) {
            log.error(Ssurgeon.class.getName(), "writeToFile");
            log.error(e);
        }
    }

    public static String writeToString(SsurgeonPattern pattern) {
        try {
            LinkedList<SsurgeonPattern> patterns = new LinkedList<SsurgeonPattern>();
            patterns.add(pattern);
            Document domDoc = Ssurgeon.createPatternXMLDoc(patterns);
            if (domDoc != null) {
                Transformer tformer = TransformerFactory.newInstance().newTransformer();
                tformer.setOutputProperty("indent", "yes");
                StringWriter sw = new StringWriter();
                tformer.transform(new DOMSource(domDoc), new StreamResult(sw));
                return sw.toString();
            }
            log.warning("Was not able to create XML document for pattern list.");
        }
        catch (Exception e) {
            log.info("Error in writeToString, could not process pattern=" + pattern);
            log.info(e);
            return null;
        }
        return "";
    }

    private static Document createPatternXMLDoc(List<SsurgeonPattern> patterns) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document domDoc = db.newDocument();
            Element rootElt = domDoc.createElement("ssurgeon-pattern-list");
            domDoc.appendChild(rootElt);
            int ordinal = 1;
            for (SsurgeonPattern pattern : patterns) {
                Element patElt = domDoc.createElement("ssurgeon-pattern");
                patElt.setAttribute("ordinal", String.valueOf(ordinal));
                Element semgrexElt = domDoc.createElement("semgrex");
                semgrexElt.appendChild(domDoc.createTextNode(pattern.getSemgrexPattern().pattern()));
                patElt.appendChild(semgrexElt);
                Element uidElem = domDoc.createElement("uid");
                uidElem.appendChild(domDoc.createTextNode(pattern.getUID()));
                patElt.appendChild(uidElem);
                Element notesElem = domDoc.createElement("notes");
                notesElem.appendChild(domDoc.createTextNode(pattern.getNotes()));
                patElt.appendChild(notesElem);
                SemanticGraph semgrexGraph = pattern.getSemgrexGraph();
                if (semgrexGraph != null) {
                    Element patNode = domDoc.createElement("semgrex-graph");
                    patNode.appendChild(domDoc.createTextNode(semgrexGraph.toCompactString()));
                }
                Element editList = domDoc.createElement("edit-list");
                patElt.appendChild(editList);
                int editOrdinal = 1;
                for (SsurgeonEdit edit : pattern.getEditScript()) {
                    Element editElem = domDoc.createElement("edit");
                    editElem.setAttribute("ordinal", String.valueOf(editOrdinal));
                    editElem.appendChild(domDoc.createTextNode(edit.toEditString()));
                    editList.appendChild(editElem);
                    ++editOrdinal;
                }
                rootElt.appendChild(patElt);
                ++ordinal;
            }
            return domDoc;
        }
        catch (Exception e) {
            log.error(Ssurgeon.class.getName(), "createPatternXML");
            log.error(e);
            return null;
        }
    }

    public List<SsurgeonPattern> readFromFile(File file) throws Exception {
        ArrayList<SsurgeonPattern> retList = new ArrayList<SsurgeonPattern>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        NodeList patternNodes = doc.getElementsByTagName("ssurgeon-pattern");
        for (int i = 0; i < patternNodes.getLength(); ++i) {
            Node node = patternNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element elt = (Element)node;
            SsurgeonPattern pattern = Ssurgeon.ssurgeonPatternFromXML(elt);
            retList.add(pattern);
        }
        NodeList resourceNodes = doc.getElementsByTagName("resource");
        for (int i = 0; i < resourceNodes.getLength(); ++i) {
            Node node = patternNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element resourceElt = (Element)node;
            SsurgeonWordlist wlRsrc = new SsurgeonWordlist(resourceElt);
            this.addResource(wlRsrc);
        }
        return retList;
    }

    public List<SsurgeonPattern> readFromDirectory(File dir) throws Exception {
        if (!dir.isDirectory()) {
            throw new Exception("Given path not a directory, path=" + dir.getAbsolutePath());
        }
        File[] files = dir.listFiles((dir1, name) -> name.toLowerCase().endsWith(".xml"));
        ArrayList<SsurgeonPattern> patterns = new ArrayList<SsurgeonPattern>();
        for (File file : files) {
            try {
                patterns.addAll(this.readFromFile(file));
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        return patterns;
    }

    public static SsurgeonPattern ssurgeonPatternFromXML(Element elt) throws Exception {
        String uid = Ssurgeon.getTagText(elt, "uid");
        String notes = Ssurgeon.getTagText(elt, "notes");
        String semgrexString = Ssurgeon.getTagText(elt, "semgrex");
        SemgrexPattern semgrexPattern = SemgrexPattern.compile(semgrexString);
        SsurgeonPattern retPattern = new SsurgeonPattern(uid, semgrexPattern);
        retPattern.setNotes(notes);
        NodeList editNodes = elt.getElementsByTagName("edit-list");
        for (int i = 0; i < editNodes.getLength(); ++i) {
            Node node = editNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element editElt = (Element)node;
            String editVal = Ssurgeon.getEltText(editElt);
            retPattern.addEdit(Ssurgeon.parseEditLine(editVal));
        }
        Element predElt = Ssurgeon.getFirstTag(elt, "predicate");
        if (predElt != null) {
            SsurgPred pred = Ssurgeon.assemblePredFromXML(Ssurgeon.getFirstChildElement(predElt));
            retPattern.setPredicate(pred);
        }
        return retPattern;
    }

    public static SsurgPred assemblePredFromXML(Element elt) throws Exception {
        String eltName;
        switch (eltName = elt.getTagName()) {
            case "and": {
                SsurgAndPred andPred = new SsurgAndPred();
                Iterator<Element> iterator = Ssurgeon.getChildElements(elt).iterator();
                if (!iterator.hasNext()) break;
                Element childElt = iterator.next();
                SsurgPred childPred = Ssurgeon.assemblePredFromXML(childElt);
                andPred.add(childPred);
                return andPred;
            }
            case "or": {
                SsurgOrPred orPred = new SsurgOrPred();
                Iterator<Element> childElt = Ssurgeon.getChildElements(elt).iterator();
                if (!childElt.hasNext()) break;
                Element childElt2 = childElt.next();
                SsurgPred childPred = Ssurgeon.assemblePredFromXML(childElt2);
                orPred.add(childPred);
                return orPred;
            }
            case "wordlist-test": {
                String id = elt.getAttribute("id");
                String resourceID = elt.getAttribute("resourceID");
                String typeStr = elt.getAttribute("type");
                String matchName = Ssurgeon.getEltText(elt).trim();
                if (matchName == null) {
                    throw new Exception("Could not find match name for " + elt);
                }
                if (id == null) {
                    throw new Exception("No ID attribute for element = " + elt);
                }
                return new WordlistTest(id, resourceID, typeStr, matchName);
            }
        }
        throw new Exception("Invalid node encountered during Ssurgeon predicate processing, node name=" + eltName);
    }

    public void testRead(File tgtDirPath) throws Exception {
        List<SsurgeonPattern> patterns = this.readFromDirectory(tgtDirPath);
        System.out.println("Patterns, num = " + patterns.size());
        int num = 1;
        for (SsurgeonPattern pattern : patterns) {
            System.out.println("\n# " + num++);
            System.out.println(pattern);
        }
        System.out.println("\n\nRESOURCES ");
        for (SsurgeonWordlist rsrc : Ssurgeon.inst().getResources()) {
            System.out.println(rsrc + "* * * * *");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        boolean runFlag = true;
        Ssurgeon.inst().initLog(new File("./ssurgeon_run.log"));
        while (runFlag) {
            try {
                System.out.println("Enter a sentence:");
                String line = in.readLine();
                if (line.isEmpty()) {
                    System.exit(0);
                }
                System.out.println("Parsing...");
                SemanticGraph sg = SemanticGraph.valueOf(line);
                System.out.println("Graph = " + sg);
                Collection<SemanticGraph> generated = Ssurgeon.inst().exhaustFromPatterns(patterns, sg);
                System.out.println("# generated = " + generated.size());
                int index = 1;
                for (SemanticGraph gsg : generated) {
                    System.out.println("\n# " + index);
                    System.out.println(gsg);
                    ++index;
                }
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    public static String getTagText(Element element, String tag) {
        try {
            Element firstElt = Ssurgeon.getFirstTag(element, tag);
            if (firstElt == null) {
                return "";
            }
            return Ssurgeon.getEltText(firstElt);
        }
        catch (Exception e) {
            log.warning("Exception thrown attempting to get tag text for tag=" + tag + ", from element=" + element);
            return "";
        }
    }

    public static String getEltText(Element element) {
        try {
            NodeList childNodeList = element.getChildNodes();
            if (childNodeList.getLength() == 0) {
                return "";
            }
            return childNodeList.item(0).getNodeValue();
        }
        catch (Exception e) {
            log.warning("Exception e=" + e.getMessage() + " thrown calling getEltText on element=" + element);
            return "";
        }
    }

    private static Element getFirstTag(Element element, String tag) {
        try {
            NodeList nodeList = element.getElementsByTagName(tag);
            if (nodeList.getLength() == 0) {
                return null;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                return (Element)node;
            }
        }
        catch (Exception e) {
            log.warning("Error getting first tag " + tag + " under element=" + element);
        }
        return null;
    }

    private static Element getFirstChildElement(Element element) {
        try {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                return (Element)node;
            }
        }
        catch (Exception e) {
            log.warning("Error getting first child Element for element=" + element + ", exception=" + e);
        }
        return null;
    }

    private static List<Element> getChildElements(Element element) {
        LinkedList<Element> childElements = new LinkedList<Element>();
        try {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                childElements.add((Element)node);
            }
        }
        catch (Exception e) {
            log.warning("Exception thrown getting all children for element=" + element + ", e=" + e);
        }
        return childElements;
    }

    public static void main(String[] args) {
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            if (args[argIndex].equalsIgnoreCase("-info")) {
                Ssurgeon.argsBox.info = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-patterns")) {
                Ssurgeon.argsBox.patternDirStr = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (!args[argIndex].equalsIgnoreCase("-type")) continue;
            Ssurgeon.argsBox.type = RUNTYPE.valueOf(args[argIndex + 1]);
            argIndex += 2;
        }
        if (Ssurgeon.argsBox.patternDirStr == null) {
            throw new IllegalArgumentException("Need to give a pattern location with -patterns");
        }
        argsBox.init();
        System.out.println(argsBox);
        try {
            if (Ssurgeon.argsBox.type == RUNTYPE.interactive) {
                Ssurgeon.inst().testRead(Ssurgeon.argsBox.patternDir);
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    public static class ArgsBox {
        public RUNTYPE type = RUNTYPE.interactive;
        public String patternDirStr = null;
        public File patternDir = null;
        public String info = null;
        public File infoPath = null;

        public void init() {
            this.patternDir = new File(this.patternDirStr);
            if (this.type == RUNTYPE.testinfo) {
                this.infoPath = new File(this.info);
            }
        }

        public String toString() {
            StringWriter buf = new StringWriter();
            buf.write("type =" + (Object)((Object)this.type) + "\n");
            buf.write("pattern dir = " + this.patternDir.getAbsolutePath());
            if (this.type == RUNTYPE.testinfo) {
                buf.write("info file = " + this.info);
                if (this.info != null) {
                    buf.write(", path = " + this.infoPath.getAbsolutePath());
                }
            }
            return buf.toString();
        }
    }

    public static enum RUNTYPE {
        interactive,
        testinfo;

    }

    protected static class SsurgeonArgs {
        public String govNodeName = null;
        public String dep = null;
        public String edge = null;
        public String reln = null;
        public String node = null;
        public String nodeString = null;
        public double weight = 1.0;
        public String name = null;

        protected SsurgeonArgs() {
        }
    }
}

