/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.trees.GrammaticalRelation;
import java.io.StringWriter;

public class RemoveNamedEdge
extends SsurgeonEdit {
    public static final String LABEL = "removeNamedEdge";
    protected String edgeName;
    protected String govName;
    protected String depName;

    public RemoveNamedEdge(String edgeName, String govName, String depName) {
        this.edgeName = edgeName;
        this.govName = govName;
        this.depName = depName;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-edge");
        buf.write(" ");
        buf.write(this.edgeName);
        buf.write("\t");
        buf.write("-gov");
        buf.write(" ");
        buf.write(this.govName);
        buf.write("\t");
        buf.write("-dep");
        buf.write(" ");
        buf.write(this.depName);
        return buf.toString();
    }

    @Override
    public void evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        IndexedWord depNode;
        String relation = sm.getRelnString(this.edgeName);
        IndexedWord govNode = this.getNamedNode(this.govName, sm);
        SemanticGraphEdge edge = sg.getEdge(govNode, depNode = this.getNamedNode(this.depName, sm), GrammaticalRelation.valueOf(relation));
        if (edge != null) {
            sg.removeEdge(edge);
        }
    }

    public String getDepName() {
        return this.depName;
    }

    public String getEdgeName() {
        return this.edgeName;
    }

    public String getGovName() {
        return this.govName;
    }
}

