/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphUtils;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.Generics;
import java.io.StringWriter;
import java.util.Map;

public class AddDep
extends SsurgeonEdit {
    public static final String LABEL = "addDep";
    IndexedWord newNodePrototype;
    GrammaticalRelation relation;
    String govNodeName;
    double weight;
    public static final String WORD_KEY = "word";
    public static final String LEMMA_KEY = "lemma";
    public static final String VALUE_KEY = "value";
    public static final String CURRENT_KEY = "current";
    public static final String POS_KEY = "POS";
    public static final String TUPLE_DELIMITER = "=";
    public static final String ATOM_DELIMITER = " ";

    public static AddDep createEngAddDep(String govNodeName, String engRelation, String newNode) {
        GrammaticalRelation relation = EnglishGrammaticalRelations.valueOf(engRelation);
        IndexedWord newNodeObj = AddDep.fromCheapString(newNode);
        return new AddDep(govNodeName, relation, newNodeObj);
    }

    public AddDep(String govNodeName, GrammaticalRelation relation, IndexedWord newNodePrototype) {
        this.newNodePrototype = newNodePrototype;
        this.relation = relation;
        this.govNodeName = govNodeName;
        this.weight = 0.0;
    }

    public AddDep(String govNodeName, GrammaticalRelation relation, IndexedWord newNodePrototype, double weight) {
        this(govNodeName, relation, newNodePrototype);
        this.weight = weight;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-gov");
        buf.write(ATOM_DELIMITER);
        buf.write(this.govNodeName);
        buf.write("\t");
        buf.write("-reln");
        buf.write(ATOM_DELIMITER);
        buf.write(this.relation.toString());
        buf.write("\t");
        buf.write("-nodearg");
        buf.write(ATOM_DELIMITER);
        buf.write("\"");
        buf.write(AddDep.cheapWordToString(this.newNodePrototype));
        buf.write("\"\t");
        buf.write("-weight");
        buf.write(ATOM_DELIMITER);
        buf.write(String.valueOf(this.weight));
        return buf.toString();
    }

    @Override
    public void evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        IndexedWord govNode = sm.getNode(this.govNodeName);
        IndexedWord newNode = new IndexedWord(this.newNodePrototype);
        int newIndex = SemanticGraphUtils.leftMostChildVertice(govNode, sg).index();
        newNode.setDocID(govNode.docID());
        newNode.setIndex(newIndex);
        newNode.setSentIndex(govNode.sentIndex());
        sg.addVertex(newNode);
        sg.addEdge(govNode, newNode, this.relation, this.weight, false);
    }

    public static String cheapWordToString(IndexedWord node) {
        StringWriter buf = new StringWriter();
        buf.write("{");
        buf.write(WORD_KEY);
        buf.write(TUPLE_DELIMITER);
        buf.write(AddDep.nullShield(node.word()));
        buf.write(ATOM_DELIMITER);
        buf.write(LEMMA_KEY);
        buf.write(TUPLE_DELIMITER);
        buf.write(AddDep.nullShield(node.lemma()));
        buf.write(ATOM_DELIMITER);
        buf.write(POS_KEY);
        buf.write(TUPLE_DELIMITER);
        buf.write(AddDep.nullShield(node.tag()));
        buf.write(ATOM_DELIMITER);
        buf.write(VALUE_KEY);
        buf.write(TUPLE_DELIMITER);
        buf.write(AddDep.nullShield(node.value()));
        buf.write(ATOM_DELIMITER);
        buf.write(CURRENT_KEY);
        buf.write(TUPLE_DELIMITER);
        buf.write(AddDep.nullShield(node.originalText()));
        buf.write("}");
        return buf.toString();
    }

    public static IndexedWord fromCheapString(String rawArg) {
        String arg = rawArg.substring(1, rawArg.length() - 1);
        String[] tuples = arg.split(ATOM_DELIMITER);
        Map<String, String> args = Generics.newHashMap();
        for (String tuple : tuples) {
            String[] vals = tuple.split(TUPLE_DELIMITER);
            String key = vals[0];
            String value = "";
            if (vals.length == 2) {
                value = vals[1];
            }
            args.put(key, value);
        }
        IndexedWord newWord = new IndexedWord();
        newWord.setWord((String)args.get(WORD_KEY));
        newWord.setLemma((String)args.get(LEMMA_KEY));
        newWord.setTag((String)args.get(POS_KEY));
        newWord.setValue((String)args.get(VALUE_KEY));
        newWord.setOriginalText((String)args.get(CURRENT_KEY));
        return newWord;
    }

    public static String nullShield(String str) {
        return str == null ? "" : str;
    }
}

