/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.process.WordShapeClassifier;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;

public class WordShapeClassifierTest
extends TestCase {
    private static String[] inputs = new String[]{"fabulous", "J\u00f8rgensen", "--", "beta-carotene", "x-ray", "A.", "supercalifragilisticexpialadocious", "58", "59,000", "NF-kappa", "Exxon-Mobil", "a", "A4", "IFN-gamma-inducible", "PPARgamma", "NF-kappaB", "CBF1/RBP-Jkappa", "", "It's", "A-4", "congr\u00e8s", "3,35%", "6\u20ac", "}", "\u300a", "\uff10-\uff19", "\u56db\u5343", "\u4e94\u4ebf\u25ef", "\uff30\uff31", "\u0627\u0644\u062d\u0631\u0627\u0632\u064a", "2008", "427891", "A.B.C.", "22-34", "Ak47", "frEaKy", "\u7f8e\u65b9\u79f0", "alphabeta", "betaalpha", "betalpha", "alpha-beta", "beta-alpha", "zalphabeta", "zbetaalpha", "zbetalpha", "zalpha-beta", "zbeta-alpha"};
    private static String[] chris1outputs = new String[]{"LOWERCASE", "CAPITALIZED", "SYMBOL", "LOWERCASE-DASH", "LOWERCASE-DASH", "ACRONYM1", "LOWERCASE", "CARDINAL13", "NUMBER", "CAPITALIZED-DASH", "CAPITALIZED-DASH", "LOWERCASE", "ALLCAPS-DIGIT", "CAPITALIZED-DASH", "CAPITALIZED", "CAPITALIZED-DASH", "CAPITALIZED-DIGIT-DASH", "SYMBOL", "CAPITALIZED", "ALLCAPS-DIGIT-DASH", "LOWERCASE", "SYMBOL-DIGIT", "SYMBOL-DIGIT", "SYMBOL", "SYMBOL", "DIGIT-DASH", "LOWERCASE", "LOWERCASE", "ALLCAPS", "LOWERCASE", "CARDINAL4", "CARDINAL5PLUS", "ACRONYM", "DIGIT-DASH", "CAPITALIZED-DIGIT", "MIXEDCASE", "LOWERCASE", "LOWERCASE", "LOWERCASE", "LOWERCASE", "LOWERCASE-DASH", "LOWERCASE-DASH", "LOWERCASE", "LOWERCASE", "LOWERCASE", "LOWERCASE-DASH", "LOWERCASE-DASH"};
    private static String[] chris2outputs = new String[]{"xxxxx", "Xxxxx", "--", "g-xxx", "x-xxx", "X.", "xxxxx", "dd", "dd,ddd", "XX-g", "Xx-Xxxx", "x", "Xd", "XX-Xgxxx", "XXXg", "XX-gX", "XX-/Xdg", "", "Xx'x", "X-d", "xxxxx", "d,dd%", "d\u20ac", "}", "\u300a", "d-d", "\u56db\u5343", "\u4e94\u4ebf\u25ef", "XX", "\u0627\u0644\u0627\u062d\u0631\u0632\u064a", "dddd", "ddddd", "X..XX.", "dd-dd", "Xxdd", "xxXxXx", "\u7f8e\u65b9\u79f0", "gg", "gg", "gxxx", "g-g", "g-g", "xgg", "xgg", "xgxxx", "xg-g", "xg-g"};
    private static String[] chris2KnownLCoutputs = new String[]{"xxxxxk", "Xxxxx", "--", "g-xxx", "x-xxx", "X.", "xxxxx", "dd", "dd,ddd", "XX-g", "Xx-Xxxx", "xk", "Xd", "XX-Xgxxx", "XXXg", "XX-gX", "XX-/Xdg", "", "Xx'x", "X-d", "xxxxx", "d,dd%", "d\u20ac", "}", "\u300a", "d-d", "\u56db\u5343", "\u4e94\u4ebf\u25ef", "XX", "\u0627\u0644\u0627\u062d\u0631\u0632\u064a", "dddd", "ddddd", "X..XX.", "dd-dd", "Xxdd", "xxXxXx", "\u7f8e\u65b9\u79f0", "gg", "gg", "gxxx", "g-g", "g-g", "xgg", "xgg", "xgxxx", "xg-g", "xg-g"};
    private static String[] chris3outputs = new String[]{"xxxx", "Xxxx", "--", "g-xx", "x-xx", "X.", "xxxx", "dd", "dd,dd", "XX-g", "Xx-xx", "x", "Xd", "XX-gxx", "XXg", "XX-gX", "XX-/dg", "", "Xx'x", "X-d", "xxxx", "d,d%", "d\u20ac", "}", "\u300a", "d-d", "\u56db\u5343", "\u4e94\u4ebf\u25ef", "XX", "\u0627\u0644\u062d\u0631\u0632\u064a", "dddd", "dddd", "X.X.", "dd-dd", "Xxdd", "xxXx", "\u7f8e\u65b9\u79f0", "g", "g", "gxx", "g-", "g-", "xg", "xg", "xgxx", "xg-", "xg-"};
    private static String[] chris3KnownLCoutputs = new String[]{"xxxxk", "Xxxx", "--", "g-xx", "x-xx", "X.", "xxxx", "dd", "dd,dd", "XX-g", "Xx-xx", "xk", "Xd", "XX-gxx", "XXg", "XX-gX", "XX-/dg", "", "Xx'x", "X-d", "xxxx", "d,d%", "d\u20ac", "}", "\u300a", "d-d", "\u56db\u5343", "\u4e94\u4ebf\u25ef", "XX", "\u0627\u0644\u062d\u0631\u0632\u064a", "dddd", "dddd", "X.X.", "dd-dd", "Xxdd", "xxXx", "\u7f8e\u65b9\u79f0", "g", "g", "gxx", "g-", "g-", "xg", "xg", "xgxx", "xg-", "xg-"};
    private static String[] chris4outputs = new String[]{"xxxxx", "Xxxxx", "--", "g-xxx", "x-xxx", "X.", "xxxxx", "dd", "dd.ddd", "XX-g", "Xx-Xxxx", "x", "Xd", "XX-Xgxxx", "XXXg", "XX-gX", "XX-.Xdg", "", "Xx'x", "X-d", "xxxxx", "d.dd%", "d$", ")", "(", "d-d", "dd", "ddd", "XX", "ccccc", "dddd", "ddddd", "X..XX.", "dd-dd", "Xxdd", "xxXxXx", "ccc", "gg", "gg", "gxxx", "g-g", "g-g", "xgg", "xgg", "xgxxx", "xg-g", "xg-g"};
    private static String[] chris4KnownLCoutputs = new String[]{"xxxxxk", "Xxxxx", "--", "g-xxx", "x-xxx", "X.", "xxxxx", "dd", "dd.ddd", "XX-g", "Xx-Xxxx", "xk", "Xd", "XX-Xgxxx", "XXXg", "XX-gX", "XX-.Xdg", "", "Xx'x", "X-d", "xxxxx", "d.dd%", "d$", ")", "(", "d-d", "dd", "ddd", "XX", "ccccc", "dddd", "ddddd", "X..XX.", "dd-dd", "Xxdd", "xxXxXx", "ccc", "gg", "gg", "gxxx", "g-g", "g-g", "xgg", "xgg", "xgxxx", "xg-g", "xg-g"};
    private static String[] digitsOutputs = new String[]{"fabulous", "J\u00f8rgensen", "--", "beta-carotene", "x-ray", "A.", "supercalifragilisticexpialadocious", "99", "99,999", "NF-kappa", "Exxon-Mobil", "a", "A9", "IFN-gamma-inducible", "PPARgamma", "NF-kappaB", "CBF9/RBP-Jkappa", "", "It's", "A-9", "congr\u00e8s", "9,99%", "9\u20ac", "}", "\u300a", "9-9", "\u56db\u5343", "\u4e94\u4ebf\u25ef", "\uff30\uff31", "\u0627\u0644\u062d\u0631\u0627\u0632\u064a", "9999", "999999", "A.B.C.", "99-99", "Ak99", "frEaKy", "\u7f8e\u65b9\u79f0", "alphabeta", "betaalpha", "betalpha", "alpha-beta", "beta-alpha", "zalphabeta", "zbetaalpha", "zbetalpha", "zalpha-beta", "zbeta-alpha"};
    private static String[] knownLC = new String[]{"house", "fabulous", "octopus", "a"};

    public static void genericCheck(int wordshape, String[] in, String[] shape, String[] knownLCWords) {
        WordShapeClassifierTest.assertEquals((String)"WordShapeClassifierTest is bung: array sizes differ", (int)in.length, (int)shape.length);
        HashSet<String> knownLCset = null;
        if (knownLCWords != null) {
            knownLCset = new HashSet<String>(Arrays.asList(knownLC));
        }
        for (int i = 0; i < in.length; ++i) {
            WordShapeClassifierTest.assertEquals((String)("WordShape " + wordshape + " for " + in[i] + " with " + (knownLCset == null ? "null" : "non-null") + " knownLCwords is not correct!"), (String)shape[i], (String)WordShapeClassifier.wordShape(in[i], wordshape, knownLCset));
        }
        try {
            WordShapeClassifier.wordShape(null, wordshape);
            WordShapeClassifierTest.fail((String)"WordShapeClassifier threw no exception on null");
        }
        catch (NullPointerException i) {
        }
        catch (Exception e) {
            WordShapeClassifierTest.fail((String)"WordShapeClassifier didn't throw NullPointerException on null");
        }
    }

    public static void outputResults(int wordshape, String[] in, String[] shape, String[] knownLCWords) {
        System.out.println("======================");
        System.out.println(" Classifier " + wordshape);
        System.out.println("======================");
        HashSet<String> knownLCset = null;
        if (knownLCWords != null) {
            knownLCset = new HashSet<String>(Arrays.asList(knownLC));
        }
        for (int i = 0; i < in.length; ++i) {
            String result = WordShapeClassifier.wordShape(in[i], wordshape, knownLCset);
            System.out.print("  " + in[i] + ": " + result);
            if (i < shape.length) {
                System.out.print("  (" + shape[i] + ")");
            }
            System.out.println();
        }
    }

    public void testChris1() {
        WordShapeClassifierTest.genericCheck(1, inputs, chris1outputs, null);
    }

    public void testChris2() {
        WordShapeClassifierTest.genericCheck(8, inputs, chris2outputs, null);
        WordShapeClassifierTest.genericCheck(9, inputs, chris2KnownLCoutputs, knownLC);
    }

    public void testChris3() {
        WordShapeClassifierTest.genericCheck(10, inputs, chris3outputs, null);
        WordShapeClassifierTest.genericCheck(11, inputs, chris3KnownLCoutputs, knownLC);
    }

    public void testChris4() {
        WordShapeClassifierTest.genericCheck(12, inputs, chris4outputs, null);
        WordShapeClassifierTest.genericCheck(12, inputs, chris4KnownLCoutputs, knownLC);
    }

    public void testDigits() {
        WordShapeClassifierTest.genericCheck(13, inputs, digitsOutputs, null);
    }
}

