/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.process.TSVSentenceIterator;
import edu.stanford.nlp.process.TSVUtils;
import edu.stanford.nlp.simple.Sentence;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public class TSVSentenceIteratorITest {
    public void testOnlyGloss() {
        List<List<String>> entries = Collections.singletonList(Arrays.asList("124", "docid1", "1", "This is a test document."));
        TSVSentenceIterator it = new TSVSentenceIterator(entries.iterator(), Arrays.asList(TSVSentenceIterator.SentenceField.ID, TSVSentenceIterator.SentenceField.DOC_ID, TSVSentenceIterator.SentenceField.SENTENCE_INDEX, TSVSentenceIterator.SentenceField.GLOSS));
        Sentence sentence = it.next();
        Assert.assertEquals((long)1L, (long)sentence.sentenceIndex());
        Assert.assertEquals((Object)"This is a test document.", (Object)sentence.text());
        Assert.assertEquals((Object)"docid1", sentence.asCoreMap(new Function[0]).get(CoreAnnotations.DocIDAnnotation.class));
        Assert.assertEquals((Object)"124", sentence.asCoreMap(new Function[0]).get(CoreAnnotations.SentenceIDAnnotation.class));
    }

    @Test
    public void testFullTokens() {
        List<List<String>> entries = Collections.singletonList(Arrays.asList("3424", "d2-s1-a1", "0", "{Chess,is,not,a,predominantly,physical,sport,\"\",\"\",yet,neither,are,shooting,and,curling,-LRB-,which,\"\",\"\",in,fact,\"\",\"\",has,been,nicknamed,``,chess,on,ice,'',5,-RRB-,.}", "{chess,be,not,a,predominantly,physical,sport,\"\",\"\",yet,neither,be,shooting,and,curling,-lrb-,which,\"\",\"\",in,fact,\"\",\"\",have,be,nickname,``,chess,on,ice,'',5,-rrb-,.}", "{NN,VBZ,RB,DT,RB,JJ,NN,\"\",\"\",RB,DT,VBP,JJ,CC,NN,-LRB-,WDT,\"\",\"\",IN,NN,\"\",\"\",VBZ,VBN,VBN,``,NN,IN,NN,'',LS,-RRB-,.}", "{O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,NUMBER,O,O}", "{0,6,9,13,15,29,38,43,45,49,57,61,70,74,82,83,88,90,93,97,99,103,108,118,119,125,128,131,132,133,134}", "{5,8,12,14,28,37,43,44,48,56,60,69,73,81,83,88,89,92,97,98,102,107,117,119,124,127,131,132,133,134,135}", "Chess is not a predominantly physical sport, yet neither are shooting and curling (which, in fact, has been nicknamed \u201cchess on ice\u201d5)."));
        TSVSentenceIterator it = new TSVSentenceIterator(entries.iterator(), Arrays.asList(TSVSentenceIterator.SentenceField.ID, TSVSentenceIterator.SentenceField.DOC_ID, TSVSentenceIterator.SentenceField.SENTENCE_INDEX, TSVSentenceIterator.SentenceField.WORDS, TSVSentenceIterator.SentenceField.LEMMAS, TSVSentenceIterator.SentenceField.POS_TAGS, TSVSentenceIterator.SentenceField.NER_TAGS, TSVSentenceIterator.SentenceField.DOC_CHAR_BEGIN, TSVSentenceIterator.SentenceField.DOC_CHAR_END, TSVSentenceIterator.SentenceField.GLOSS));
        Sentence sentence = it.next();
        Assert.assertEquals((Object)"3424", (Object)sentence.sentenceid().orElse("-1"));
        Assert.assertEquals((Object)"d2-s1-a1", (Object)sentence.document.docid().orElse("???"));
        Assert.assertEquals((long)0L, (long)sentence.sentenceIndex());
        Assert.assertEquals((Object)"Chess is not a predominantly physical sport, yet neither are shooting and curling (which, in fact, has been nicknamed \u201cchess on ice\u201d5).", (Object)sentence.text());
        Assert.assertArrayEquals((Object[])new String[]{"Chess", "is", "not", "a", "predominantly", "physical", "sport", ",", "yet", "neither", "are", "shooting", "and", "curling", "-LRB-", "which", ",", "in", "fact", ",", "has", "been", "nicknamed", "``", "chess", "on", "ice", "''", "5", "-RRB-", "."}, (Object[])sentence.words().toArray());
        Assert.assertArrayEquals((Object[])new String[]{"chess", "be", "not", "a", "predominantly", "physical", "sport", ",", "yet", "neither", "be", "shooting", "and", "curling", "-lrb-", "which", ",", "in", "fact", ",", "have", "be", "nickname", "``", "chess", "on", "ice", "''", "5", "-rrb-", "."}, (Object[])sentence.lemmas().toArray());
        Assert.assertArrayEquals((Object[])new String[]{"NN", "VBZ", "RB", "DT", "RB", "JJ", "NN", ",", "RB", "DT", "VBP", "JJ", "CC", "NN", "-LRB-", "WDT", ",", "IN", "NN", ",", "VBZ", "VBN", "VBN", "``", "NN", "IN", "NN", "''", "LS", "-RRB-", "."}, (Object[])sentence.posTags().toArray());
        Assert.assertArrayEquals((Object[])new String[]{"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "NUMBER", "O", "O"}, (Object[])sentence.nerTags().toArray());
        Assert.assertArrayEquals((Object[])new Integer[]{0, 6, 9, 13, 15, 29, 38, 43, 45, 49, 57, 61, 70, 74, 82, 83, 88, 90, 93, 97, 99, 103, 108, 118, 119, 125, 128, 131, 132, 133, 134}, (Object[])sentence.characterOffsetBegin().toArray());
        Assert.assertArrayEquals((Object[])new Integer[]{5, 8, 12, 14, 28, 37, 43, 44, 48, 56, 60, 69, 73, 81, 83, 88, 89, 92, 97, 98, 102, 107, 117, 119, 124, 127, 131, 132, 133, 134, 135}, (Object[])sentence.characterOffsetEnd().toArray());
    }

    @Test
    public void testParseArray() {
        String in = "{Chess,is,not,a,predominantly,physical,sport,\"\",\"\",yet,neither,are,shooting,and,curling,-LRB-,which,\"\",\"\",in,fact,\"\",\"\",has,been,nicknamed,``,chess,on,ice,'',5,-RRB-,.}";
        Object[] out2 = new String[]{"Chess", "is", "not", "a", "predominantly", "physical", "sport", ",", "yet", "neither", "are", "shooting", "and", "curling", "-LRB-", "which", ",", "in", "fact", ",", "has", "been", "nicknamed", "``", "chess", "on", "ice", "''", "5", "-RRB-", "."};
        Assert.assertArrayEquals((Object[])out2, (Object[])TSVUtils.parseArray(in).toArray());
    }

    @Test
    public void testParseTrees() {
        List<List<String>> entries = Collections.singletonList(Arrays.asList("3424", "d2-s1-a1", "0", "{Chess,is,not,a,predominantly,physical,sport,\"\",\"\",yet,neither,are,shooting,and,curling,-LRB-,which,\"\",\"\",in,fact,\"\",\"\",has,been,nicknamed,``,chess,on,ice,'',5,-RRB-,.}", "{chess,be,not,a,predominantly,physical,sport,\"\",\"\",yet,neither,be,shooting,and,curling,-lrb-,which,\"\",\"\",in,fact,\"\",\"\",have,be,nickname,``,chess,on,ice,'',5,-rrb-,.}", "{NN,VBZ,RB,DT,RB,JJ,NN,\"\",\"\",RB,DT,VBP,JJ,CC,NN,-LRB-,WDT,\"\",\"\",IN,NN,\"\",\"\",VBZ,VBN,VBN,``,NN,IN,NN,'',LS,-RRB-,.}", "{O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,NUMBER,O,O}", "{0,6,9,13,15,29,38,43,45,49,57,61,70,74,82,83,88,90,93,97,99,103,108,118,119,125,128,131,132,133,134}", "{5,8,12,14,28,37,43,44,48,56,60,69,73,81,83,88,89,92,97,98,102,107,117,119,124,127,131,132,133,134,135}", "[{\"\"dependent\"\": 7, \"\"dep\"\": \"\"ROOT\"\", \"\"governorGloss\"\": \"\"ROOT\"\", \"\"governor\"\": 0, \"\"dependentGloss\"\": \"\"sport\"\"}, {\"\"dependent\"\": 1, \"\"dep\"\": \"\"nsubj\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"Chess\"\"}, {\"\"dependent\"\": 2, \"\"dep\"\": \"\"cop\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"is\"\"}, {\"\"dependent\"\": 3, \"\"dep\"\": \"\"neg\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"not\"\"}, {\"\"dependent\"\": 4, \"\"dep\"\": \"\"det\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"a\"\"}, {\"\"dependent\"\": 5, \"\"dep\"\": \"\"advmod\"\", \"\"governorGloss\"\": \"\"physical\"\", \"\"governor\"\": 6, \"\"dependentGloss\"\": \"\"predominantly\"\"}, {\"\"dependent\"\": 6, \"\"dep\"\": \"\"amod\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"physical\"\"}, {\"\"dependent\"\": 9, \"\"dep\"\": \"\"advmod\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"yet\"\"}, {\"\"dependent\"\": 10, \"\"dep\"\": \"\"nsubj\"\", \"\"governorGloss\"\": \"\"shooting\"\", \"\"governor\"\": 12, \"\"dependentGloss\"\": \"\"neither\"\"}, {\"\"dependent\"\": 11, \"\"dep\"\": \"\"cop\"\", \"\"governorGloss\"\": \"\"shooting\"\", \"\"governor\"\": 12, \"\"dependentGloss\"\": \"\"are\"\"}, {\"\"dependent\"\": 12, \"\"dep\"\": \"\"parataxis\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"shooting\"\"}, {\"\"dependent\"\": 13, \"\"dep\"\": \"\"cc\"\", \"\"governorGloss\"\": \"\"shooting\"\", \"\"governor\"\": 12, \"\"dependentGloss\"\": \"\"and\"\"}, {\"\"dependent\"\": 14, \"\"dep\"\": \"\"parataxis\"\", \"\"governorGloss\"\": \"\"sport\"\", \"\"governor\"\": 7, \"\"dependentGloss\"\": \"\"curling\"\"}, {\"\"dependent\"\": 14, \"\"dep\"\": \"\"conj:and\"\", \"\"governorGloss\"\": \"\"shooting\"\", \"\"governor\"\": 12, \"\"dependentGloss\"\": \"\"curling\"\"}, {\"\"dependent\"\": 16, \"\"dep\"\": \"\"nsubjpass\"\", \"\"governorGloss\"\": \"\"nicknamed\"\", \"\"governor\"\": 23, \"\"dependentGloss\"\": \"\"which\"\"}, {\"\"dependent\"\": 18, \"\"dep\"\": \"\"case\"\", \"\"governorGloss\"\": \"\"fact\"\", \"\"governor\"\": 19, \"\"dependentGloss\"\": \"\"in\"\"}, {\"\"dependent\"\": 19, \"\"dep\"\": \"\"nmod:in\"\", \"\"governorGloss\"\": \"\"nicknamed\"\", \"\"governor\"\": 23, \"\"dependentGloss\"\": \"\"fact\"\"}, {\"\"dependent\"\": 21, \"\"dep\"\": \"\"aux\"\", \"\"governorGloss\"\": \"\"nicknamed\"\", \"\"governor\"\": 23, \"\"dependentGloss\"\": \"\"has\"\"}, {\"\"dependent\"\": 22, \"\"dep\"\": \"\"auxpass\"\", \"\"governorGloss\"\": \"\"nicknamed\"\", \"\"governor\"\": 23, \"\"dependentGloss\"\": \"\"been\"\"}, {\"\"dependent\"\": 23, \"\"dep\"\": \"\"dep\"\", \"\"governorGloss\"\": \"\"shooting\"\", \"\"governor\"\": 12, \"\"dependentGloss\"\": \"\"nicknamed\"\"}, {\"\"dependent\"\": 25, \"\"dep\"\": \"\"dobj\"\", \"\"governorGloss\"\": \"\"nicknamed\"\", \"\"governor\"\": 23, \"\"dependentGloss\"\": \"\"chess\"\"}, {\"\"dependent\"\": 26, \"\"dep\"\": \"\"case\"\", \"\"governorGloss\"\": \"\"ice\"\", \"\"governor\"\": 27, \"\"dependentGloss\"\": \"\"on\"\"}, {\"\"dependent\"\": 27, \"\"dep\"\": \"\"nmod:on\"\", \"\"governorGloss\"\": \"\"chess\"\", \"\"governor\"\": 25, \"\"dependentGloss\"\": \"\"ice\"\"}, {\"\"dependent\"\": 29, \"\"dep\"\": \"\"amod\"\", \"\"governorGloss\"\": \"\"chess\"\", \"\"governor\"\": 25, \"\"dependentGloss\"\": \"\"5\"\"}]", "Chess is not a predominantly physical sport, yet neither are shooting and curling (which, in fact, has been nicknamed \u201cchess on ice\u201d5)."));
        TSVSentenceIterator it = new TSVSentenceIterator(entries.iterator(), Arrays.asList(TSVSentenceIterator.SentenceField.ID, TSVSentenceIterator.SentenceField.DOC_ID, TSVSentenceIterator.SentenceField.SENTENCE_INDEX, TSVSentenceIterator.SentenceField.WORDS, TSVSentenceIterator.SentenceField.LEMMAS, TSVSentenceIterator.SentenceField.POS_TAGS, TSVSentenceIterator.SentenceField.NER_TAGS, TSVSentenceIterator.SentenceField.DOC_CHAR_BEGIN, TSVSentenceIterator.SentenceField.DOC_CHAR_END, TSVSentenceIterator.SentenceField.DEPENDENCIES_BASIC, TSVSentenceIterator.SentenceField.GLOSS));
        Sentence sentence = it.next();
        sentence.dependencyGraph();
        sentence.openieTriples();
    }
}

