/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.util.Properties;
import junit.framework.TestCase;

public class PronominalMentionITest
extends TestCase {
    public String sampleText = "President Barack Obama was born in August. His birthday was August 4th, 1961.";
    public StanfordCoreNLP pipeline;

    public void setUp() {
    }

    public void testCorefExample() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,depparse,coref");
        this.pipeline = new StanfordCoreNLP(props);
        CoreDocument sampleDoc = new CoreDocument(this.sampleText);
        this.pipeline.annotate(sampleDoc);
        PronominalMentionITest.assertEquals((String)"Barack Obama", (String)sampleDoc.entityMentions().get(1).text());
        CoreMap pronominalMention = sampleDoc.entityMentions().get(4).coreMap();
        PronominalMentionITest.assertEquals((String)"His", (String)((String)pronominalMention.get(CoreAnnotations.TextAnnotation.class)));
        PronominalMentionITest.assertEquals((int)1, (int)((Integer)pronominalMention.get(CoreAnnotations.CanonicalEntityMentionIndexAnnotation.class)));
    }
}

