/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.MorphaAnnotator;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.util.ArrayCoreMap;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MorphaAnnotatorITest {
    private static AnnotationPipeline fullPipeline;
    private static AnnotationPipeline shortPipeline;
    private static final String text = "I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .";
    private static final String[] answer;
    private static final String[] tokenizedText;
    private static final String[] tokenizedTags;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        Class<MorphaAnnotatorITest> clazz = MorphaAnnotatorITest.class;
        synchronized (MorphaAnnotatorITest.class) {
            if (fullPipeline == null) {
                fullPipeline = new AnnotationPipeline();
                fullPipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
                fullPipeline.addAnnotator(new WordsToSentencesAnnotator(false));
                fullPipeline.addAnnotator(new POSTaggerAnnotator(false));
                fullPipeline.addAnnotator(new MorphaAnnotator(false));
            }
            if (shortPipeline == null) {
                shortPipeline = new AnnotationPipeline();
                shortPipeline.addAnnotator(new MorphaAnnotator(false));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void checkResult(List<CoreLabel> words) {
        Assert.assertEquals((long)words.size(), (long)answer.length);
        for (int i = 0; i < answer.length; ++i) {
            CoreLabel word = words.get(i);
            String lemma = (String)word.get(CoreAnnotations.LemmaAnnotation.class);
            Assert.assertEquals((Object)lemma, (Object)answer[i]);
        }
    }

    @Test
    public void testMorphaAnnotator() {
        Annotation document = new Annotation(text);
        fullPipeline.annotate(document);
        MorphaAnnotatorITest.checkResult((List)document.get(CoreAnnotations.TokensAnnotation.class));
    }

    private static List<CoreLabel> getTestWords() {
        ArrayList<CoreLabel> words = new ArrayList<CoreLabel>();
        if (tokenizedText.length != tokenizedTags.length) {
            throw new AssertionError((Object)"tokenizedText and tokenizedTags must be of the same length");
        }
        for (int i = 0; i < tokenizedText.length; ++i) {
            CoreLabel word = new CoreLabel();
            word.setWord(tokenizedText[i]);
            word.set(CoreAnnotations.TextAnnotation.class, tokenizedText[i]);
            word.setTag(tokenizedTags[i]);
            words.add(word);
        }
        return words;
    }

    @Test
    public void testSentencesAnnotation() {
        List<CoreLabel> words = MorphaAnnotatorITest.getTestWords();
        ArrayCoreMap sentence = new ArrayCoreMap();
        sentence.set(CoreAnnotations.TokensAnnotation.class, words);
        ArrayList<ArrayCoreMap> sentences = new ArrayList<ArrayCoreMap>();
        sentences.add(sentence);
        Annotation document = new Annotation(text);
        document.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        shortPipeline.annotate(document);
        MorphaAnnotatorITest.checkResult(words);
    }

    static {
        answer = new String[]{"I", "see", "he", "order", "they", "to", "saw", ".", "Jack", "'s", "father", "have", "not", "play", "golf", "since", "20", "year", "ago", ".", "I", "be", "go", "to", "the", "bookstore", "to", "return", "a", "book", "Jack", "and", "he", "friend", "buy", "I", "."};
        tokenizedText = new String[]{"I", "saw", "him", "ordering", "them", "to", "saw", ".", "Jack", "'s", "father", "has", "n't", "played", "golf", "since", "20", "years", "ago", ".", "I", "'m", "going", "to", "the", "bookstore", "to", "return", "a", "book", "Jack", "and", "his", "friends", "bought", "me", "."};
        tokenizedTags = new String[]{"PRP", "VBD", "PRP", "VBG", "PRP", "TO", "NN", ".", "NNP", "POS", "NN", "VBZ", "RB", "VBN", "NN", "IN", "CD", "NNS", "RB", ".", "PRP", "VBP", "VBG", "TO", "DT", "NN", "TO", "VB", "DT", "NN", "NNP", "CC", "PRP$", "NNS", "VBD", "PRP", "."};
    }
}

