/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GenericAnnotationSerializer
extends AnnotationSerializer {
    boolean compress = false;

    public GenericAnnotationSerializer(boolean compress) {
        this.compress = compress;
    }

    public GenericAnnotationSerializer() {
        this(false);
    }

    @Override
    public OutputStream write(Annotation corpus, OutputStream os) throws IOException {
        if (os instanceof AppendingObjectOutputStream) {
            ((AppendingObjectOutputStream)os).writeObject(corpus);
            return os;
        }
        if (os instanceof ObjectOutputStream) {
            AppendingObjectOutputStream objectOutput = new AppendingObjectOutputStream(this.compress ? new GZIPOutputStream(os) : os);
            objectOutput.writeObject(corpus);
            return objectOutput;
        }
        ObjectOutputStream objectOutput = new ObjectOutputStream(this.compress ? new GZIPOutputStream(os) : os);
        objectOutput.writeObject(corpus);
        return objectOutput;
    }

    @Override
    public Pair<Annotation, InputStream> read(InputStream is) throws IOException, ClassNotFoundException, ClassCastException {
        ObjectInputStream objectInput = is instanceof ObjectInputStream ? (ObjectInputStream)is : new ObjectInputStream(this.compress ? new GZIPInputStream(is) : is);
        Object annotation = objectInput.readObject();
        if (annotation == null) {
            return null;
        }
        if (!(annotation instanceof Annotation)) {
            throw new ClassCastException("ERROR: Serialized data does not contain an Annotation!");
        }
        return Pair.makePair((Annotation)annotation, objectInput);
    }

    public static class AppendingObjectOutputStream
    extends ObjectOutputStream {
        public AppendingObjectOutputStream(OutputStream out2) throws IOException {
            super(out2);
        }

        @Override
        protected void writeStreamHeader() throws IOException {
            this.reset();
        }
    }
}

