/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class GenderAnnotator
implements Annotator {
    private static Redwood.RedwoodChannels log = Redwood.channels(GenderAnnotator.class);
    public static String MALE_FIRST_NAMES_PATH = "edu/stanford/nlp/models/gender/male_first_names.txt";
    public static String FEMALE_FIRST_NAMES_PATH = "edu/stanford/nlp/models/gender/female_first_names.txt";
    public HashSet<String> maleNames = new HashSet();
    public HashSet<String> femaleNames = new HashSet();

    public void loadGenderNames(HashSet<String> genderSet, String filePath) {
        List<String> nameFileEntries = IOUtils.linesFromFile(filePath);
        for (String nameCSV : nameFileEntries) {
            String[] namesForThisLine;
            for (String name : namesForThisLine = nameCSV.split(",")) {
                genderSet.add(name.toLowerCase());
            }
        }
    }

    public void annotateEntityMention(CoreMap entityMention, String gender) {
        entityMention.set(CoreAnnotations.GenderAnnotation.class, gender);
        for (CoreLabel token : (List)entityMention.get(CoreAnnotations.TokensAnnotation.class)) {
            token.set(CoreAnnotations.GenderAnnotation.class, gender);
        }
    }

    public GenderAnnotator(String annotatorName, Properties props) {
        MALE_FIRST_NAMES_PATH = props.getProperty("gender.maleNamesFile", MALE_FIRST_NAMES_PATH);
        FEMALE_FIRST_NAMES_PATH = props.getProperty("gender.femaleNamesFile", FEMALE_FIRST_NAMES_PATH);
        this.loadGenderNames(this.maleNames, MALE_FIRST_NAMES_PATH);
        this.loadGenderNames(this.femaleNames, FEMALE_FIRST_NAMES_PATH);
    }

    @Override
    public void annotate(Annotation annotation) {
        for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap entityMention : (List)sentence.get(CoreAnnotations.MentionsAnnotation.class)) {
                if (!((String)entityMention.get(CoreAnnotations.EntityTypeAnnotation.class)).equals("PERSON")) continue;
                CoreLabel firstName = (CoreLabel)((List)entityMention.get(CoreAnnotations.TokensAnnotation.class)).get(0);
                if (this.maleNames.contains(firstName.word().toLowerCase())) {
                    this.annotateEntityMention(entityMention, "MALE");
                    continue;
                }
                if (!this.femaleNames.contains(firstName.word().toLowerCase())) continue;
                this.annotateEntityMention(entityMention, "FEMALE");
            }
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.MentionsAnnotation.class, CoreAnnotations.EntityTypeAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(CoreAnnotations.GenderAnnotation.class);
    }
}

