/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class EntityMentionCorefITest
extends TestCase {
    public String apostropheText = "President Barack Obama's presidency started in 2009. Before that Obama defeated John McCain in the 2008 presidential election. Barack Obama served two terms.";
    public StanfordCoreNLP pipeline;
    AnnotationSerializer serializer;

    public void setUp() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,depparse,coref");
        this.pipeline = new StanfordCoreNLP(props);
        this.serializer = new ProtobufAnnotationSerializer();
    }

    public void testApostropheMatch() {
        Annotation sampleAnnotation = new Annotation(this.apostropheText);
        this.pipeline.annotate(sampleAnnotation);
        CoreMap entityMention = (CoreMap)((List)sampleAnnotation.get(CoreAnnotations.MentionsAnnotation.class)).get(3);
        int matchingEntityMentionIndex = (Integer)entityMention.get(CoreAnnotations.CanonicalEntityMentionIndexAnnotation.class);
        EntityMentionCorefITest.assertEquals((int)1, (int)matchingEntityMentionIndex);
    }
}

